/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.data.ServerSkillTreeData;
import de.teamlapen.vampirism.network.ClientboundSkillTreePacket;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.world.LevelFog;
import de.teamlapen.vampirism.world.LevelGarlic;
import de.teamlapen.vampirism.world.MinionWorldData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GeneralEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onPlayerLoggedIn(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        Player player = event.getEntity();
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().isDedicatedServer() || UtilLib.isPlayerOp(player);
        if (isAdminLikePlayer && !ModList.get().isLoaded("guideapi_vp") && ((Boolean)VampirismConfig.SERVER.infoAboutGuideAPI.get()).booleanValue()) {
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.guideapi_available.first"));
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.guideapi_available.download").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/guide-api-village-and-pillage")).withUnderlined(Boolean.valueOf(true))));
            VampirismConfig.SERVER.infoAboutGuideAPI.set((Object)false);
        }
        if (player instanceof ServerPlayer && !Permissions.isSetupCorrectly((ServerPlayer)player)) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + String.valueOf(ChatFormatting.DARK_PURPLE) + "Vampirism" + String.valueOf(ChatFormatting.RESET) + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + Permissions.GENERAL_CHECK.getNodeName() + "' to suppress this warning).")));
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre event) {
        MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer()).tick();
    }

    @SubscribeEvent
    public void onWorldUnload(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            LevelFog.get(level).clearCache();
            LevelGarlic.get(level).clearCache();
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        int missing = ModLootTables.checkAndResetInsertedAll();
        if (missing > 0) {
            LOGGER.warn("LootTables Failed to inject {} loottables", (Object)missing);
        }
    }

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        ClientboundSkillTreePacket skillTrees = ClientboundSkillTreePacket.of(ServerSkillTreeData.instance().getConfigurations());
        if (event.getPlayer() != null) {
            event.getPlayer().connection.send((CustomPacketPayload)skillTrees);
        } else {
            event.getPlayerList().getPlayers().forEach(p -> p.connection.send((CustomPacketPayload)skillTrees));
        }
    }
}

