/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import de.teamlapen.lib.lib.util.UtilLib;
import java.util.Collections;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSpawnerLogic<T extends Entity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    @NotNull
    private final EntityType<T> entityType;
    @Nullable
    private Consumer<T> onSpawned;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int activateRange = 16;
    private int dailyLimit = Integer.MAX_VALUE;
    private int spawnCount = 1;
    private int maxNearbyEntities = 4;
    private int spawnRange = 4;
    private int spawnDelay = 20;
    private int spawnedToday = 0;
    private long spawnedLast = 0L;
    private boolean flag = true;
    private MobCategory limitType;
    private final Random rng = new Random();

    public SimpleSpawnerLogic(@NotNull EntityType<T> entityTypeIn) {
        this.entityType = entityTypeIn;
    }

    @NotNull
    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    public int getSpawnedToday() {
        return this.spawnedToday;
    }

    public boolean isActivated(@Nullable Level level, @Nullable BlockPos pos) {
        if (level == null) {
            return false;
        }
        if (pos == null) {
            return false;
        }
        return level.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)this.activateRange);
    }

    public void readFromNbt(@NotNull CompoundTag nbt) {
        this.spawnDelay = nbt.getInt("delay");
        this.spawnedToday = nbt.getInt("spawned_today");
        this.spawnedLast = nbt.getLong("spawned_last");
        this.flag = nbt.getBoolean("spawner_flag");
    }

    @NotNull
    public SimpleSpawnerLogic<T> setActivateRange(int activateRange) {
        this.activateRange = activateRange;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setDailyLimit(int dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    public boolean setDelayToMin(int id, @NotNull Level level) {
        if (id == 1 && level.isClientSide) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setLimitTotalEntities(MobCategory creatureType) {
        this.limitType = creatureType;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setMaxSpawnDelay(int maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setMinSpawnDelay(int minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setOnSpawned(Consumer<T> onSpawned) {
        this.onSpawned = onSpawned;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setSpawn(boolean spawn) {
        this.flag = spawn;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setSpawnCount(int spawnCount) {
        this.spawnCount = spawnCount;
        return this;
    }

    @NotNull
    public SimpleSpawnerLogic<T> setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
        return this;
    }

    public void serverTick(Level level, @NotNull BlockPos pos) {
        if (this.isActivated(level, pos) && level instanceof ServerLevel) {
            Entity entity;
            if (this.spawnDelay == -1) {
                this.resetTimer();
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            if (level.getGameTime() > this.spawnedLast + 24000L) {
                this.spawnedToday = 0;
                this.flag = true;
            } else if (this.spawnedToday >= this.dailyLimit) {
                this.flag = false;
            }
            if (!this.flag) {
                return;
            }
            boolean flag1 = false;
            for (int i = 0; i < this.spawnCount && (entity = this.getEntityType().create(level)) != null; ++i) {
                int j = level.getEntitiesOfClass(entity.getClass(), this.getSpawningBox(pos).inflate(5.0)).size();
                if (j >= this.maxNearbyEntities) {
                    this.resetTimer();
                    break;
                }
                if (this.limitType != null) {
                    // Could not load outer class - annotation placement on inner may be incorrect
                     @Nullable NaturalSpawner.SpawnState densityManager = ((ServerLevel)level).getChunkSource().getLastSpawnState();
                    try {
                        if (densityManager != null && !densityManager.canSpawnForCategory(this.limitType, new ChunkPos(pos.getX() / 16, pos.getZ() / 16))) {
                            this.resetTimer();
                            break;
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                if (!UtilLib.spawnEntityInWorld((ServerLevel)level, this.getSpawningBox(pos), entity, 1, Collections.emptyList(), MobSpawnType.SPAWNER)) continue;
                this.onSpawned(entity);
                flag1 = true;
            }
            if (flag1) {
                this.resetTimer();
                ++this.spawnedToday;
                this.spawnedLast = level.getGameTime();
            }
        }
    }

    public void writeToNbt(@NotNull CompoundTag nbt) {
        nbt.putInt("delay", this.spawnDelay);
        nbt.putInt("spawned_today", this.spawnedToday);
        nbt.putLong("spawned_last", this.spawnedLast);
        nbt.putBoolean("spawner_flag", this.flag);
    }

    @NotNull
    protected AABB getSpawningBox(@Nullable BlockPos pos) {
        if (pos == null) {
            return AABB.ofSize((Vec3)Vec3.ZERO, (double)0.0, (double)0.0, (double)0.0);
        }
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)this.spawnRange, (double)this.spawnRange, (double)this.spawnRange);
    }

    protected void onSpawned(T e) {
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            mob.spawnAnim();
        }
        if (this.onSpawned != null) {
            this.onSpawned.accept(e);
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.rng.nextInt(i);
        }
    }
}

