/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib;

import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.lib.network.ClientboundUpdateEntityPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HelperLib {
    public static <T extends Entity> void sync(@NotNull T entity) {
        if (!entity.getCommandSenderWorld().isClientSide) {
            ClientboundUpdateEntityPacket m = ClientboundUpdateEntityPacket.create(entity);
            HelperLib.sendToAll(entity, m);
        }
    }

    public static <T extends Entity> void sync(@NotNull T entity, CompoundTag data) {
        if (!entity.getCommandSenderWorld().isClientSide) {
            ClientboundUpdateEntityPacket m = ClientboundUpdateEntityPacket.create(entity, data);
            HelperLib.sendToAll(entity, m);
        }
    }

    public static void sync(@NotNull IAttachedSyncable cap, @NotNull Entity entity, boolean all) {
        if (!entity.getCommandSenderWorld().isClientSide) {
            ClientboundUpdateEntityPacket m = ClientboundUpdateEntityPacket.create((HolderLookup.Provider)entity.registryAccess(), cap);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.connection != null) {
                    player.connection.send((CustomPacketPayload)m);
                }
            }
            if (all) {
                HelperLib.sendToAll(entity, m);
            }
        }
    }

    public static void sync(Object object, Entity entity, boolean all) {
        if (!entity.level().isClientSide() && object instanceof IAttachedSyncable) {
            IAttachedSyncable cap = (IAttachedSyncable)object;
            ClientboundUpdateEntityPacket m = ClientboundUpdateEntityPacket.create((HolderLookup.Provider)entity.registryAccess(), cap);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.connection != null) {
                    player.connection.send((CustomPacketPayload)m);
                }
            }
            if (all) {
                HelperLib.sendToAll(entity, m);
            }
        }
    }

    private static void sendToAll(@NotNull Entity entity, CustomPacketPayload packetPayload) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ServerChunkCache serverchunkcache = level2.getChunkSource();
            serverchunkcache.broadcast(entity, packetPayload);
        }
    }

    public static void sync(@NotNull IAttachedSyncable cap, @NotNull CompoundTag data, @NotNull Entity entity, boolean all) {
        if (!entity.getCommandSenderWorld().isClientSide) {
            ClientboundUpdateEntityPacket m = ClientboundUpdateEntityPacket.create(cap, data);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.connection != null) {
                    player.connection.send((CustomPacketPayload)m);
                }
            }
            if (all) {
                HelperLib.sendToAll(entity, m);
            }
        }
    }
}

