/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.items;

import com.focamacho.vampiresneedumbrellas.config.ConfigHolder;
import com.focamacho.vampiresneedumbrellas.handlers.VampirismHandler;
import com.focamacho.vampiresneedumbrellas.utils.Utils;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class ItemUmbrella
extends Item {
    private static final UUID SPEED_ATTRIBUTE = UUID.fromString("278caaa5-8912-490c-acb1-d3c10bac2150");
    private final Supplier<Integer> durabilitySupplier;
    private final Supplier<Double> speedSupplier;
    private final Item repairItem;

    public ItemUmbrella(Item.Properties builder, Supplier<Integer> durabilitySupplier, Supplier<Double> speedSupplier, Item repairItem) {
        super(builder.durability(100));
        this.durabilitySupplier = durabilitySupplier;
        this.speedSupplier = speedSupplier;
        this.repairItem = repairItem;
    }

    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isVampirismLoaded) {
            VampirismHandler.applyEffect(stack, worldIn, entityIn, this.isDamageable(stack));
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder attributes = ItemAttributeModifiers.builder();
        AttributeModifier modifier = new AttributeModifier(ResourceLocation.parse((String)"vampiresneedumbrellas:umbrella_modifier"), this.speedSupplier.get().doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        attributes.add(Attributes.MOVEMENT_SPEED, modifier, EquipmentSlotGroup.MAINHAND);
        attributes.add(Attributes.MOVEMENT_SPEED, modifier, EquipmentSlotGroup.OFFHAND);
        return attributes.build();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durabilitySupplier.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ConfigHolder.umbrellaAnvil;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.durabilitySupplier.get() != -1;
    }

    @ParametersAreNonnullByDefault
    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return ConfigHolder.umbrellaRepair && repair.getItem().equals(this.repairItem);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)this.getMaxDamage(stack));
    }

    @ParametersAreNonnullByDefault
    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, ((float)this.getMaxDamage(stack) - (float)stack.getDamageValue()) / (float)this.getMaxDamage(stack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

