/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.undergroundvillages.datagen;

import com.mrbysco.undergroundvillages.datagen.StructureUpdater;
import com.mrbysco.undergroundvillages.feature.ConfiguredUndergroundStructureTags;
import com.mrbysco.undergroundvillages.registration.ModPlacedFeatures;
import com.mrbysco.undergroundvillages.registration.ModProcessorLists;
import com.mrbysco.undergroundvillages.registration.ModStructureSets;
import com.mrbysco.undergroundvillages.registration.ModStructures;
import com.mrbysco.undergroundvillages.registration.ModTemplatePools;
import com.mrbysco.undergroundvillages.util.UndergroundBiomeTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class UndergroundDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> UndergroundDatagen.getProvider().full());
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(UndergroundDatagen::getProvider), Set.of("underground_villages")));
        generator.addProvider(event.includeServer(), (DataProvider)new UndergroundStructureFeatureTagProvider(packOutput, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UndergroundBiomeTagProvider(packOutput, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new StructureUpdater("structure/village", "underground_villages", helper, packOutput));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, context -> {});
        registryBuilder.add(Registries.PLACED_FEATURE, ModPlacedFeatures::bootstrap);
        registryBuilder.add(Registries.PROCESSOR_LIST, ModProcessorLists::bootstrap);
        registryBuilder.add(Registries.STRUCTURE, ModStructures::bootstrap);
        registryBuilder.add(Registries.STRUCTURE_SET, ModStructureSets::bootstrap);
        registryBuilder.add(Registries.TEMPLATE_POOL, ModTemplatePools::bootstrap);
        registryBuilder.add(Registries.BIOME, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    public static class UndergroundStructureFeatureTagProvider
    extends StructureTagsProvider {
        public UndergroundStructureFeatureTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "underground_villages", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ConfiguredUndergroundStructureTags.UNDERGROUND_VILLAGE).add(ModStructures.UNDERGROUND_VILLAGE);
        }

        public String getName() {
            return "Configured Underground Structure Feature Tags";
        }
    }

    public static class UndergroundBiomeTagProvider
    extends BiomeTagsProvider {
        public UndergroundBiomeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "underground_villages", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(UndergroundBiomeTags.HAS_VILLAGE_UNDERGROUND).add(new ResourceKey[]{Biomes.DESERT, Biomes.PLAINS, Biomes.MEADOW, Biomes.SAVANNA, Biomes.SNOWY_PLAINS, Biomes.TAIGA});
        }
    }
}

