/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;

public class BabyStray
extends Stray {
    public BabyStray(EntityType<? extends Stray> entityType, Level level) {
        super(entityType, level);
        this.xpReward = (int)((float)this.xpReward * 2.5f);
        this.refreshDimensions();
    }

    public static boolean checkBabyStraySpawnRules(EntityType<BabyStray> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return BabyStray.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (mobSpawnType == MobSpawnType.SPAWNER || serverLevelAccessor.canSeeSky(blockPos));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 15.0f){

            public boolean canUse() {
                return super.canUse() && BabyStray.this.getMainHandItem().getItem() == Items.SNOWBALL;
            }
        });
        super.registerGoals();
    }

    public float getPickRadius() {
        return 0.3f;
    }

    public boolean isBaby() {
        return true;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).withEyeHeight(this.getType().getDimensions().eyeHeight() * (this.isBaby() ? 0.534f : 1.0f));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.SNOWBALL));
    }

    public void reassessWeaponGoal() {
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        Snowball snowball = new Snowball(this, this.level(), (LivingEntity)this){

            protected void onHitEntity(EntityHitResult hitResult) {
                Entity entity = hitResult.getEntity();
                entity.hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), 0.5f);
            }
        };
        double d0 = target.getEyeY() - (double)1.1f;
        double d1 = target.getX() - this.getX();
        double d2 = d0 - snowball.getY();
        double d3 = target.getZ() - this.getZ();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * 0.2;
        snowball.shoot(d1, d2 + f, d3, 1.6f, 14.0f - (float)this.level().getDifficulty().getId() * 2.0f);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)snowball);
        this.swing(InteractionHand.MAIN_HAND);
    }
}

