/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import fuzs.tinyskeletons.init.ModRegistry;
import fuzs.tinyskeletons.mixin.accessor.LivingEntityAccessor;
import fuzs.tinyskeletons.world.entity.ai.goal.RangedBowEasyAttackGoal;
import fuzs.tinyskeletons.world.entity.monster.BabyStray;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BabySkeleton
extends Skeleton {
    private RangedBowAttackGoal<AbstractSkeleton> bowGoal;
    private MeleeAttackGoal meleeGoal;
    private int switchWeaponCooldown;

    public BabySkeleton(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
        this.xpReward = (int)((float)this.xpReward * 2.5f);
        this.refreshDimensions();
    }

    public float getPickRadius() {
        return 0.3f;
    }

    public boolean isBaby() {
        return true;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).withEyeHeight(this.getType().getDimensions().eyeHeight() * (this.isBaby() ? 0.534f : 1.0f));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    protected void doFreezeConversion() {
        BabyStray stray = (BabyStray)this.convertTo((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.value(), true);
        if (stray != null) {
            ((LivingEntityAccessor)((Object)stray)).tinyskeletons$callDetectEquipmentUpdates();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stray.setItemSlot(slot, ItemStack.EMPTY);
            }
            stray.populateDefaultEquipmentSlots(this.random, stray.level().getCurrentDifficultyAt(stray.blockPosition()));
        }
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1048, this.blockPosition(), 0);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.switchWeaponCooldown > 0) {
                --this.switchWeaponCooldown;
            }
            if (this.switchWeaponCooldown == 0) {
                if (this.getTarget() != null && (double)this.distanceTo((Entity)this.getTarget()) < 4.0) {
                    if (this.getMainHandItem().getItem() instanceof BowItem) {
                        this.setHandItems(this.getOffhandItem(), this.getMainHandItem());
                        this.switchWeaponCooldown = 60;
                    }
                } else if ((this.getTarget() == null || (double)this.distanceTo((Entity)this.getTarget()) > 8.0) && this.getMainHandItem().getItem() instanceof SwordItem) {
                    this.setHandItems(this.getOffhandItem(), this.getMainHandItem());
                    this.switchWeaponCooldown = 60;
                }
            }
        }
    }

    public void reassessWeaponGoal() {
        if (this.level() != null && !this.level().isClientSide) {
            if (this.bowGoal == null || this.meleeGoal == null) {
                this.createAttackGoals();
            }
            this.goalSelector.removeGoal((Goal)this.meleeGoal);
            this.goalSelector.removeGoal(this.bowGoal);
            if (this.getMainHandItem().getItem() instanceof BowItem) {
                int minAttackInterval = 20;
                if (this.level().getDifficulty() != Difficulty.HARD) {
                    minAttackInterval = 40;
                }
                this.bowGoal.setMinAttackInterval(minAttackInterval);
                this.goalSelector.addGoal(4, this.bowGoal);
            } else {
                this.goalSelector.addGoal(4, (Goal)this.meleeGoal);
            }
        }
    }

    private void setHandItems(ItemStack mainHand, ItemStack offHand) {
        this.setItemInHand(InteractionHand.MAIN_HAND, mainHand);
        this.setItemInHand(InteractionHand.OFF_HAND, offHand);
    }

    private void createAttackGoals() {
        this.bowGoal = new RangedBowEasyAttackGoal<BabySkeleton>(this, 1.0, 40, 60, 15.0f);
        this.meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            public void stop() {
                super.stop();
                BabySkeleton.this.setAggressive(false);
            }

            public void start() {
                super.start();
                BabySkeleton.this.setAggressive(true);
            }
        };
    }
}

