/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.ai.goal;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class RangedBowEasyAttackGoal<T extends Monster>
extends RangedBowAttackGoal<T> {
    private final T entity;
    private final double moveSpeedAmplifier;
    private int attackCooldown;
    private final int maxAttackTime;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;

    public RangedBowEasyAttackGoal(T mob, double chaseTargetSpeed, int attackCooldown, int maxAttackTime, float maxAttackDistance) {
        super(mob, chaseTargetSpeed, attackCooldown, maxAttackDistance);
        this.entity = mob;
        this.moveSpeedAmplifier = chaseTargetSpeed;
        this.attackCooldown = attackCooldown;
        this.maxAttackTime = maxAttackTime;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
    }

    public void setMinAttackInterval(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
    }

    public void stop() {
        this.entity.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.stopUsingItem();
    }

    public void tick() {
        LivingEntity attackTarget = this.entity.getTarget();
        if (attackTarget != null) {
            double distanceToTarget = this.entity.distanceToSqr(attackTarget.getX(), attackTarget.getY(), attackTarget.getZ());
            boolean canSeeTarget = this.entity.getSensing().hasLineOfSight((Entity)attackTarget);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            boolean moveTowardsTarget = false;
            if (distanceToTarget <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.getNavigation().stop();
                moveTowardsTarget = distanceToTarget > (double)(this.maxAttackDistance * 0.75f);
            } else {
                this.entity.getNavigation().moveTo((Entity)attackTarget, this.moveSpeedAmplifier);
            }
            if (moveTowardsTarget) {
                this.entity.getMoveControl().strafe(0.5f, 0.0f);
                this.entity.lookAt((Entity)attackTarget, 30.0f, 30.0f);
            } else {
                this.entity.getLookControl().setLookAt((Entity)attackTarget, 30.0f, 30.0f);
            }
            if (this.entity.isUsingItem()) {
                int useCount;
                if (!canSeeTarget && this.seeTime < -this.maxAttackTime) {
                    this.entity.stopUsingItem();
                } else if (canSeeTarget && (useCount = this.entity.getTicksUsingItem()) >= 20) {
                    this.entity.stopUsingItem();
                    double distanceVelocity = Math.sqrt(distanceToTarget) / Math.sqrt(this.maxAttackDistance);
                    ((RangedAttackMob)this.entity).performRangedAttack(attackTarget, Mth.clamp((float)((float)distanceVelocity), (float)0.1f, (float)1.0f) * BowItem.getPowerForTime((int)useCount));
                    this.attackTime = Mth.floor((double)(distanceVelocity * (double)((float)this.maxAttackTime - (float)this.attackCooldown / 2.0f) + (double)((float)this.attackCooldown / 2.0f)));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -this.maxAttackTime) {
                this.entity.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.entity, (Item)Items.BOW));
            }
        }
    }
}

