/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.handler;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BabyConversionHandler {
    private static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> BABY_MOB_CONVERSIONS = new HashMap<EntityType<? extends Mob>, EntityType<? extends Mob>>();

    public static void registerConversion(EntityType<? extends Mob> targetMob, EntityType<? extends Mob> convertsTo) {
        BABY_MOB_CONVERSIONS.put(targetMob, convertsTo);
    }

    public static EventResult onEntitySpawn(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        EntityType<? extends Mob> entityType;
        if (spawnType != null && spawnType != MobSpawnType.COMMAND && Zombie.getSpawnAsBabyOdds((RandomSource)level.getRandom()) && (entityType = BABY_MOB_CONVERSIONS.get(entity.getType())) != null && BabyConversionHandler.createAndSpawnBabyMob(level, entityType, entity, spawnType) != null) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity target, Vec3 hitVector) {
        EntityType eggType;
        EntityType<? extends Mob> babyType;
        ItemStack stackInHand = player.getItemInHand(hand);
        if (target.isAlive() && stackInHand.getItem() instanceof SpawnEggItem && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((SpawnEggItem)stackInHand.getItem()).getType(stackInHand))) != null && (target.getType() == babyType || target.getType() == eggType)) {
            Mob mob;
            if (!level.isClientSide && (mob = BabyConversionHandler.createAndSpawnBabyMob((ServerLevel)level, babyType, target, MobSpawnType.SPAWN_EGG)) != null) {
                BabyConversionHandler.finalizeSpawnEggMob(mob, stackInHand, player);
            }
            return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
        return EventResultHolder.pass();
    }

    private static void finalizeSpawnEggMob(Mob mob, ItemStack itemstack, Player player) {
        mob.playAmbientSound();
        if (itemstack.has(DataComponents.CUSTOM_NAME)) {
            mob.setCustomName(itemstack.getHoverName());
        }
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)itemstack.getItem()));
    }

    @Nullable
    private static Mob createAndSpawnBabyMob(ServerLevel level, EntityType<? extends Mob> entityType, Entity parent, MobSpawnType spawnReason) {
        Mob mob;
        if (parent instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)parent;
            mob = ageableMob.getBreedOffspring(level, ageableMob);
        } else {
            mob = (Mob)entityType.create((Level)level);
        }
        if (mob == null) {
            return null;
        }
        Preconditions.checkState((boolean)mob.isBaby(), (Object)"Baby mob must be a baby by default");
        mob.moveTo(parent.getX(), parent.getY(), parent.getZ(), Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
        mob.yHeadRot = mob.getYRot();
        mob.yBodyRot = mob.getYRot();
        DifficultyInstance difficulty = new DifficultyInstance(level.getDifficulty(), level.getDayTime(), 0L, level.getMoonBrightness());
        mob.finalizeSpawn((ServerLevelAccessor)level, difficulty, spawnReason, null);
        level.addFreshEntityWithPassengers((Entity)mob);
        return mob;
    }
}

