/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.network.message;

import dev.ghen.thirst.Thirst;
import dev.ghen.thirst.compat.supernatural.SupernaturalHelper;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.content.thirst.PlayerThirst;
import dev.ghen.thirst.foundation.common.capability.ModAttachment;
import dev.ghen.thirst.foundation.config.CommonConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record DrinkByHandMessage(Vector3f pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DrinkByHandMessage> TYPE = new CustomPacketPayload.Type(Thirst.asResource("drinkbyhand"));
    public static final StreamCodec<ByteBuf, DrinkByHandMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, DrinkByHandMessage::pos, DrinkByHandMessage::new);

    public static void clientHandle(DrinkByHandMessage data, IPayloadContext context) {
    }

    public static void serverHandle(DrinkByHandMessage data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            if (((PlayerThirst)player.getData(ModAttachment.PLAYER_THIRST)).getThirst() == 20) {
                return;
            }
            if (ModList.get().isLoaded("supernatural") && SupernaturalHelper.isVampireCheck(player)) {
                return;
            }
            int purity = WaterPurity.getBlockPurity(level, new BlockPos((int)data.pos.x, (int)data.pos.y, (int)data.pos.z));
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_DRINK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (WaterPurity.givePurityEffects(player, purity)) {
                ((PlayerThirst)player.getData(ModAttachment.PLAYER_THIRST)).drink(((Number)CommonConfig.HAND_DRINKING_HYDRATION.get()).intValue(), ((Number)CommonConfig.HAND_DRINKING_QUENCHED.get()).intValue());
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

