/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin;

import dev.ghen.thirst.content.purity.WaterPurity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FluidBucketWrapper.class}, remap=false)
public class MixinFluidBucketWrapper {
    @Shadow
    @NotNull
    protected ItemStack container;

    @Overwrite
    @NotNull
    public FluidStack getFluid() {
        Item item = this.container.getItem();
        if (item instanceof BucketItem) {
            FluidStack stack = new FluidStack(((BucketItem)item).content, 1000);
            if (WaterPurity.hasPurity(this.container)) {
                WaterPurity.addPurity(stack, (int)WaterPurity.getPurity(this.container));
            }
            return stack;
        }
        if (item instanceof MilkBucketItem && NeoForgeMod.MILK.isBound()) {
            return new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
        }
        return FluidStack.EMPTY;
    }
}

