/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.vampirism.util.Helper;
import dev.ghen.thirst.Thirst;
import dev.ghen.thirst.compat.supernatural.SupernaturalHelper;
import dev.ghen.thirst.content.thirst.PlayerThirst;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModAttachment;
import dev.ghen.thirst.foundation.config.ClientConfig;
import dev.ghen.thirst.foundation.gui.RenderGuiEvent;
import dev.ghen.thirst.foundation.gui.appleskin.HUDOverlayHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(value={Dist.CLIENT})
public class ThirstBarRenderer {
    public static IThirst PLAYER_THIRST = null;
    public static ResourceLocation THIRST_ICONS = Thirst.asResource("textures/gui/thirst_icons.png");
    public static Boolean cancelRender = false;
    public static Boolean checkIfPlayerIsVampire = false;
    static Minecraft minecraft = Minecraft.getInstance();
    protected static final RandomSource random = RandomSource.create();

    @SubscribeEvent
    public static void onBeginRenderAir(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.AIR) {
            return;
        }
        Entity vehicle = ThirstBarRenderer.minecraft.player.getVehicle();
        boolean isMounted = vehicle != null && vehicle.showVehicleHealth();
        cancelRender = false;
        if (!isMounted && !ThirstBarRenderer.minecraft.options.hideGui && HUDOverlayHandler.shouldDrawSurvivalElements(minecraft)) {
            if (checkIfPlayerIsVampire.booleanValue() && Helper.isVampire((Player)ThirstBarRenderer.minecraft.player)) {
                cancelRender = true;
                return;
            }
            if (ThirstBarRenderer.minecraft.player.isAlive() && !((PlayerThirst)ThirstBarRenderer.minecraft.player.getData(ModAttachment.PLAYER_THIRST)).getShouldTickThirst()) {
                cancelRender = true;
                return;
            }
            ThirstBarRenderer.setupOverlayRenderState(true, false);
            ThirstBarRenderer.render(event.getScreenWidth(), event.getScreenHeight(), event.getGuiGraphics());
        }
    }

    public static void setupOverlayRenderState(boolean blend, boolean depthTest) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.disableBlend();
        }
        if (depthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    public static void render(int width, int height, GuiGraphics guiGraphics) {
        minecraft.getProfiler().push("thirst");
        if (PLAYER_THIRST == null || ThirstBarRenderer.minecraft.player.tickCount % 40 == 0) {
            PLAYER_THIRST = (IThirst)ThirstBarRenderer.minecraft.player.getData(ModAttachment.PLAYER_THIRST);
        }
        ResourceLocation thirst_icons = THIRST_ICONS;
        if (ModList.get().isLoaded("supernatural")) {
            thirst_icons = SupernaturalHelper.getVampireIcons(thirst_icons, (Player)ThirstBarRenderer.minecraft.player);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)thirst_icons);
        int left = width / 2 + 91 + (Integer)ClientConfig.THIRST_BAR_X_OFFSET.get();
        int top = height - ThirstBarRenderer.minecraft.gui.rightHeight + (Integer)ClientConfig.THIRST_BAR_Y_OFFSET.get();
        ThirstBarRenderer.minecraft.gui.rightHeight += 10;
        int level = PLAYER_THIRST.getThirst();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            if ((float)PLAYER_THIRST.getQuenched() <= 0.0f && ThirstBarRenderer.minecraft.gui.getGuiTicks() % (level * 3 + 1) == 0) {
                y = top + (random.nextInt(3) - 1);
            }
            guiGraphics.blit(thirst_icons, x, y, 0.0f, 0.0f, 9, 9, 25, 9);
            if (idx < level) {
                guiGraphics.blit(thirst_icons, x, y, 16.0f, 0.0f, 9, 9, 25, 9);
                continue;
            }
            if (idx != level) continue;
            guiGraphics.blit(thirst_icons, x, y, 8.0f, 0.0f, 9, 9, 25, 9);
        }
        RenderSystem.disableBlend();
        minecraft.getProfiler().pop();
    }
}

