/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.purity;

import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.registry.ItemInit;
import dev.ghen.thirst.content.registry.ThirstComponent;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.util.MathHelper;
import dev.ghen.thirst.foundation.util.TickHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.item.TANItems;
import toughasnails.item.EmptyCanteenItem;

@EventBusSubscriber
public class WaterPurity {
    private static final List<ContainerWithPurity> waterContainers = new ArrayList<ContainerWithPurity>();
    private static final List<Block> fillablesWithPurity = new ArrayList<Block>();
    public static final int MIN_PURITY = 0;
    public static final int MAX_PURITY = 3;
    public static final IntegerProperty BLOCK_PURITY = IntegerProperty.create((String)"purity", (int)0, (int)4);
    public static boolean tanLoaded = false;

    public static void init() {
        WaterPurity.registerDispenserBehaviours();
        WaterPurity.registerContainers();
        WaterPurity.registerFillables();
        if (ModList.get().isLoaded("farmersrespite")) {
            WaterPurity.registerFarmersRespiteContainers();
        }
        if (ModList.get().isLoaded("brewinandchewin")) {
            // empty if block
        }
        if (ModList.get().isLoaded("toughasnails")) {
            WaterPurity.registerToughAsNailsContainers();
            tanLoaded = true;
        }
    }

    private static void registerContainers() {
        waterContainers.add(new ContainerWithPurity(Items.GLASS_BOTTLE, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER).getItem()).setEqualsFilled(itemStack -> itemStack.is(Items.POTION) && ((PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)));
        waterContainers.add(new ContainerWithPurity((Item)ItemInit.TERRACOTTA_BOWL.get(), (Item)ItemInit.TERRACOTTA_WATER_BOWL.get()));
        waterContainers.add(new ContainerWithPurity(Items.BUCKET, Items.WATER_BUCKET, false).canHarvestRunningWater(false));
    }

    private static void registerFillables() {
        fillablesWithPurity.add(Blocks.CAULDRON);
        fillablesWithPurity.add(Blocks.WATER_CAULDRON);
    }

    private static void registerFarmersRespiteContainers() {
    }

    private static void registerToughAsNailsContainers() {
        waterContainers.add(new ContainerWithPurity(TANItems.LEATHER_DIRTY_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.COPPER_DIRTY_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.IRON_DIRTY_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.GOLD_DIRTY_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.DIAMOND_DIRTY_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.NETHERITE_DIRTY_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.LEATHER_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.COPPER_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.IRON_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.GOLD_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.DIAMOND_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.NETHERITE_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.LEATHER_PURIFIED_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.COPPER_PURIFIED_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.IRON_PURIFIED_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.GOLD_PURIFIED_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.DIAMOND_PURIFIED_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.NETHERITE_PURIFIED_WATER_CANTEEN));
        waterContainers.add(new ContainerWithPurity(TANItems.PURIFIED_WATER_BOTTLE));
        waterContainers.add(new ContainerWithPurity(TANItems.DIRTY_WATER_BOTTLE));
        waterContainers.add(new ContainerWithPurity(TANItems.APPLE_JUICE));
        waterContainers.add(new ContainerWithPurity(TANItems.CACTUS_JUICE));
        waterContainers.add(new ContainerWithPurity(TANItems.CHORUS_FRUIT_JUICE));
        waterContainers.add(new ContainerWithPurity(TANItems.GLOW_BERRY_JUICE));
        waterContainers.add(new ContainerWithPurity(TANItems.MELON_JUICE));
        waterContainers.add(new ContainerWithPurity(TANItems.PUMPKIN_JUICE));
        waterContainers.add(new ContainerWithPurity(TANItems.SWEET_BERRY_JUICE));
    }

    @SubscribeEvent
    static void fillablesHandler(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() instanceof ServerPlayer && WaterPurity.isWaterFilledContainer(event.getItemStack())) {
            Player player = event.getEntity();
            Level level = player.level();
            BlockPos pos = event.getHitVec().getBlockPos();
            BlockState blockState = level.getBlockState(pos);
            BlockEntity entity = level.getBlockEntity(pos);
            if (WaterPurity.isFillableBlock(blockState) || entity != null && Capabilities.FluidHandler.BLOCK.getCapability(level, pos, blockState, entity, null) != null) {
                int purity = WaterPurity.getPurity(event.getItemStack());
                int blockPurity = !blockState.hasProperty((Property)BLOCK_PURITY) ? 3 : ((Integer)blockState.getValue((Property)BLOCK_PURITY) - 1 < 0 ? 3 : (Integer)blockState.getValue((Property)BLOCK_PURITY) - 1);
                TickHelper.nextTick(level, () -> {
                    BlockState blockState1 = level.getBlockState(pos);
                    if (!blockState1.hasProperty((Property)BLOCK_PURITY)) {
                        return;
                    }
                    level.setBlock(pos, (BlockState)blockState1.setValue((Property)BLOCK_PURITY, (Comparable)Integer.valueOf(Math.min(purity, blockPurity) + 1)), 0);
                });
            }
        }
    }

    @Deprecated
    public static void addContainer(ContainerWithPurity container) {
        waterContainers.add(container);
    }

    public static ItemStack getFilledContainer(ItemStack container, boolean fromFilled) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if ((fromFilled || !waterContainer.equalsEmpty(container)) && (!fromFilled || !waterContainer.equalsFilled(container))) continue;
            return waterContainer.getFilledItem().getDefaultInstance();
        }
        return ItemStack.EMPTY.copy();
    }

    @SubscribeEvent
    static void harvestRunningWater(PlayerInteractEvent.RightClickItem event) {
        ItemStack filledItem;
        SoundEvent sound;
        BlockPos blockPos;
        ItemStack item = event.getItemStack();
        if (!WaterPurity.canHarvestRunningWater(item)) {
            return;
        }
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.getFluidState(blockPos = MathHelper.getPlayerPOVHitResult(level, player, ClipContext.Fluid.ANY).getBlockPos()).is(FluidTags.WATER)) {
            return;
        }
        if (item.getItem() == Items.GLASS_BOTTLE && !level.getFluidState(blockPos).isSource()) {
            sound = SoundEvents.BOTTLE_FILL;
            filledItem = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
        } else if (item.getItem() == ItemInit.TERRACOTTA_BOWL.get()) {
            sound = SoundEvents.BUCKET_FILL;
            filledItem = new ItemStack((ItemLike)ItemInit.TERRACOTTA_WATER_BOWL.get());
        } else {
            return;
        }
        level.playSound(player, player.getX(), player.getY(), player.getZ(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockPos);
        filledItem.set(ThirstComponent.PURITY, (Object)WaterPurity.getBlockPurity(level, blockPos));
        ItemStack result = ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)filledItem);
        player.setItemInHand(event.getHand(), result);
        event.setCanceled(true);
    }

    @SubscribeEvent
    static void renderPurityTooltip(ItemTooltipEvent event) {
        int purity;
        if (WaterPurity.isWaterFilledContainer(event.getItemStack()) && (purity = WaterPurity.getPurity(event.getItemStack()).intValue()) >= 0 && purity <= 3) {
            String purityText = WaterPurity.getPurityText(purity);
            int purityColor = WaterPurity.getPurityColor(purity);
            assert (purityText != null);
            event.getToolTip().add(MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(purityText)).setStyle(Style.EMPTY.withColor(purityColor)));
        }
    }

    public static boolean isWaterFilledContainer(ItemStack item) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if (!waterContainer.equalsFilled(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyWaterContainer(ItemStack item) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if (!waterContainer.equalsEmpty(item)) continue;
            return true;
        }
        return false;
    }

    static boolean isFillableBlock(Block block) {
        for (Block fillable : fillablesWithPurity) {
            if (fillable != block) continue;
            return true;
        }
        return false;
    }

    static boolean isFillableBlock(BlockState blockState) {
        return WaterPurity.isFillableBlock(blockState.getBlock());
    }

    static boolean canHarvestRunningWater(ItemStack item) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if (!waterContainer.equalsEmpty(item) || !waterContainer.canHarvestRunningWater()) continue;
            return true;
        }
        return false;
    }

    public static Integer getPurity(ItemStack item) {
        Integer purity = (Integer)item.get(ThirstComponent.PURITY);
        if (purity == null) {
            purity = (Integer)CommonConfig.DEFAULT_PURITY.get();
            item.set(ThirstComponent.PURITY, (Object)purity);
            if (tanLoaded && Objects.equals(item.getItem().getCreatorModId(item), "toughasnails")) {
                WaterPurity.tanPurity(item);
                return (Integer)item.get(ThirstComponent.PURITY);
            }
        }
        return purity;
    }

    public static void tanPurity(ItemStack item) {
        Item item2;
        item.set(ThirstComponent.PURITY, (Object)3);
        if (item.is(TANItems.DIRTY_WATER_BOTTLE)) {
            item.set(ThirstComponent.PURITY, (Object)0);
        }
        if ((item2 = item.getItem()) instanceof EmptyCanteenItem) {
            EmptyCanteenItem canteenItem = (EmptyCanteenItem)item2;
            if (item.getItem().equals(canteenItem.getDirtyWaterCanteen())) {
                item.set(ThirstComponent.PURITY, (Object)0);
            } else if (item.getItem().equals(canteenItem.getWaterCanteen())) {
                item.set(ThirstComponent.PURITY, (Object)2);
            }
        }
    }

    public static Integer getPurity(FluidStack fluid) {
        if (fluid.get(ThirstComponent.PURITY) == null) {
            fluid.set(ThirstComponent.PURITY, (Object)((Integer)CommonConfig.DEFAULT_PURITY.get()));
        }
        return (Integer)fluid.get(ThirstComponent.PURITY);
    }

    public static String getPurityText(int purity) {
        String purityText = purity == 0 ? "dirty" : (purity == 1 ? "slightly_dirty" : (purity == 2 ? "acceptable" : "purified"));
        return MutableComponent.create((ComponentContents)new TranslatableContents("thirst.purity." + purityText, purityText, TranslatableContents.NO_ARGS)).getString();
    }

    public static int getPurityColor(int purity) {
        return purity == 0 ? 11028517 : (purity == 1 ? 7957617 : (purity == 2 ? 6128285 : 2208255));
    }

    public static int getBlockPurity(BlockState blockState) {
        return blockState.hasProperty((Property)BLOCK_PURITY) ? (Integer)blockState.getValue((Property)BLOCK_PURITY) - 1 : -1;
    }

    public static boolean hasPurity(ItemStack item) {
        return item.get(ThirstComponent.PURITY) != null;
    }

    public static boolean hasPurity(FluidStack fluid) {
        return fluid.get(ThirstComponent.PURITY) != null;
    }

    public static ItemStack addPurity(ItemStack item, BlockPos pos, Level level) {
        item.set(ThirstComponent.PURITY, (Object)WaterPurity.getBlockPurity(level, pos));
        return item;
    }

    public static ItemStack addPurity(ItemStack item, int purity) {
        item.set(ThirstComponent.PURITY, (Object)purity);
        if (purity == (Integer)CommonConfig.DEFAULT_PURITY.get()) {
            item.remove(ThirstComponent.PURITY);
        }
        return item;
    }

    public static FluidStack addPurity(FluidStack fluid, int purity) {
        fluid.set(ThirstComponent.PURITY, (Object)purity);
        if (purity == (Integer)CommonConfig.DEFAULT_PURITY.get()) {
            fluid.remove(ThirstComponent.PURITY);
        }
        return fluid;
    }

    public static int getBlockPurity(Level level, BlockPos pos) {
        int purity;
        int n = purity = (pos.getY() > ((Number)CommonConfig.MOUNTAINS_Y.get()).intValue() || pos.getY() < ((Number)CommonConfig.CAVES_Y.get()).intValue()) && pos.getY() < ((Number)CommonConfig.MOUNTAINS_Y.get()).intValue() - 32 ? 1 : 0;
        if (level.getFluidState(pos).is(FluidTags.WATER)) {
            if (!level.getFluidState(pos).isSource()) {
                purity = Math.min(purity + ((Number)CommonConfig.RUNNING_WATER_PURIFICATION_AMOUNT.get()).intValue(), 3);
            }
            return purity;
        }
        if (level.getBlockState(pos).is(Blocks.WATER_CAULDRON)) {
            return (Integer)level.getBlockState(pos).getValue((Property)BLOCK_PURITY) - 1;
        }
        return (Integer)CommonConfig.DEFAULT_PURITY.get();
    }

    public static boolean givePurityEffects(Player player, ItemStack item) {
        if (!WaterPurity.isWaterFilledContainer(item)) {
            return true;
        }
        if (!WaterPurity.hasPurity(item)) {
            return true;
        }
        if (WaterPurity.getPurity(item) != -1) {
            return WaterPurity.givePurityEffects(player, ThirstHelper.getPurity(item));
        }
        return WaterPurity.givePurityEffects(player, (Integer)CommonConfig.DEFAULT_PURITY.get());
    }

    public static boolean givePurityEffects(Player player, int purity) {
        boolean shouldRegenerate = true;
        Random random = new Random();
        float chance = random.nextFloat();
        switch (purity) {
            case 0: {
                if (chance < (float)((Number)CommonConfig.DIRTY_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.DIRTY_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                }
                shouldRegenerate = false;
                break;
            }
            case 1: {
                if (chance < (float)((Number)CommonConfig.SLIGHTLY_DIRTY_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.SLIGHTLY_DIRTY_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                }
                shouldRegenerate = false;
                break;
            }
            case 2: {
                if (chance < (float)((Number)CommonConfig.ACCEPTABLE_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.ACCEPTABLE_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                }
                shouldRegenerate = false;
                break;
            }
            case 3: {
                if (chance < (float)((Number)CommonConfig.PURIFIED_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.PURIFIED_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                }
                shouldRegenerate = false;
            }
        }
        return shouldRegenerate || (Boolean)CommonConfig.QUENCH_THIRST_WHEN_DEBUFFED.get() != false;
    }

    static void registerDispenserBehaviours() {
        DispenseItemBehavior bucketDefaultBehaviour = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.BUCKET);
        DispenseItemBehavior bottleDefaultBehaviour = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.GLASS_BOTTLE);
        DispenserBlock.registerBehavior((ItemLike)Items.BUCKET, (block, item) -> {
            BlockPos blockpos;
            ServerLevel level = block.level();
            if (level.getFluidState(blockpos = block.pos().relative((Direction)block.state().getValue((Property)DispenserBlock.FACING))).is(FluidTags.WATER) && level.getBlockState(blockpos).getFluidState().isSource()) {
                ItemStack result = new ItemStack((ItemLike)Items.WATER_BUCKET);
                return WaterPurity.getStack(block, item, (Level)level, blockpos, result, true);
            }
            return bucketDefaultBehaviour.dispense(block, item);
        });
        DispenserBlock.registerBehavior((ItemLike)Items.GLASS_BOTTLE, (block, item) -> {
            BlockPos blockpos;
            ServerLevel level = block.level();
            if (level.getFluidState(blockpos = block.pos().relative((Direction)block.state().getValue((Property)DispenserBlock.FACING))).is(FluidTags.WATER)) {
                ItemStack result = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
                return WaterPurity.getStack(block, item, (Level)level, blockpos, result, false);
            }
            return bottleDefaultBehaviour.dispense(block, item);
        });
    }

    @NotNull
    private static ItemStack getStack(BlockSource block, ItemStack item, Level level, BlockPos blockpos, ItemStack result, boolean pickupBlock) {
        level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, blockpos);
        WaterPurity.addPurity(result, blockpos, level);
        if (pickupBlock) {
            ((BucketPickup)level.getBlockState(blockpos).getBlock()).pickupBlock(null, (LevelAccessor)level, blockpos, level.getBlockState(blockpos));
        }
        item.shrink(1);
        if (item.isEmpty()) {
            return result;
        }
        if (block.blockEntity().insertItem(result) != result) {
            new DefaultDispenseItemBehavior().dispense(block, result);
        }
        return item;
    }
}

