/*
 * Decompiled with CFR 0.152.
 */
package fuzs.swordblockingmechanics.client.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class AdvancedBlockingRenderer {
    public static void renderBlockingWithSword(ItemInHandRenderer itemInHandRenderer, ArmedModel model, LivingEntity entity, ItemStack stack, ItemDisplayContext transform, HumanoidArm arm, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight) {
        poseStack.pushPose();
        model.translateToHand(arm, poseStack);
        boolean leftHand = arm == HumanoidArm.LEFT;
        AdvancedBlockingRenderer.applyItemBlockingTransform(poseStack, leftHand);
        AdvancedBlockingRenderer.applyItemTransformInverse(entity, stack, transform, poseStack, leftHand);
        itemInHandRenderer.renderItem(entity, stack, transform, leftHand, poseStack, multiBufferSource, combinedLight);
        poseStack.popPose();
    }

    private static void applyItemBlockingTransform(PoseStack poseStack, boolean leftHand) {
        poseStack.translate((leftHand ? 1.0f : -1.0f) / 16.0f, 0.4375f, 0.0625f);
        poseStack.translate(leftHand ? -0.035f : 0.05f, leftHand ? 0.045f : 0.0f, leftHand ? -0.135f : -0.1f);
        poseStack.mulPose(Axis.YP.rotationDegrees((leftHand ? -1.0f : 1.0f) * -50.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-10.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees((leftHand ? -1.0f : 1.0f) * -60.0f));
        poseStack.translate(0.0f, 0.1875f, 0.0f);
        poseStack.scale(0.625f, 0.625f, 0.625f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XN.rotationDegrees(-100.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees(leftHand ? 35.0f : 45.0f));
        poseStack.translate(0.0f, -0.3f, 0.0f);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(50.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(335.0f));
        poseStack.translate(-0.9375f, -0.0625f, 0.0f);
        poseStack.translate(0.5f, 0.5f, 0.25f);
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 0.0f, 0.28125f);
    }

    private static void applyItemTransformInverse(LivingEntity entity, ItemStack stack, ItemDisplayContext transform, PoseStack poseStack, boolean leftHand) {
        Minecraft minecraft = Minecraft.getInstance();
        BakedModel model = minecraft.getItemRenderer().getModel(stack, entity.level(), entity, 0);
        AdvancedBlockingRenderer.applyTransformInverse(model.getTransforms().getTransform(transform), leftHand, poseStack);
    }

    private static void applyTransformInverse(ItemTransform vec, boolean leftHand, PoseStack matrixStackIn) {
        if (vec != ItemTransform.NO_TRANSFORM) {
            float angleX = vec.rotation.x();
            float angleY = leftHand ? -vec.rotation.y() : vec.rotation.y();
            float angleZ = leftHand ? -vec.rotation.z() : vec.rotation.z();
            Quaternionf quaternion = new Quaternionf().rotationXYZ(angleX * ((float)Math.PI / 180), angleY * ((float)Math.PI / 180), angleZ * ((float)Math.PI / 180));
            quaternion.conjugate();
            matrixStackIn.scale(1.0f / vec.scale.x(), 1.0f / vec.scale.y(), 1.0f / vec.scale.z());
            matrixStackIn.mulPose(quaternion);
            matrixStackIn.translate((leftHand ? -1.0f : 1.0f) * -vec.translation.x(), -vec.translation.y(), -vec.translation.z());
        }
    }
}

