/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.Math;

public final class Levenshtein
implements StringMetric,
StringDistance {
    private final float maxCost;
    private final float insertDelete;
    private final float substitute;

    public Levenshtein(float insertDelete, float substitute) {
        Preconditions.checkArgument((insertDelete > 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((substitute >= 0.0f ? 1 : 0) != 0);
        this.maxCost = java.lang.Math.max(insertDelete, substitute);
        this.insertDelete = insertDelete;
        this.substitute = substitute;
    }

    public Levenshtein() {
        this(1.0f, 1.0f);
    }

    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        return 1.0f - this.distance(a, b) / (this.maxCost * (float)java.lang.Math.max(a.length(), b.length()));
    }

    @Override
    public float distance(String s, String t) {
        int i;
        if (s.isEmpty()) {
            return t.length();
        }
        if (t.isEmpty()) {
            return s.length();
        }
        if (s.equals(t)) {
            return 0.0f;
        }
        int tLength = t.length();
        int sLength = s.length();
        float[] v0 = new float[tLength + 1];
        float[] v1 = new float[tLength + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = (float)i * this.insertDelete;
        }
        for (i = 0; i < sLength; ++i) {
            v1[0] = (float)(i + 1) * this.insertDelete;
            for (int j = 0; j < tLength; ++j) {
                v1[j + 1] = Math.min(v1[j] + this.insertDelete, v0[j + 1] + this.insertDelete, v0[j] + (s.charAt(i) == t.charAt(j) ? 0.0f : this.substitute));
            }
            float[] swap = v0;
            v0 = v1;
            v1 = swap;
        }
        return v0[tLength];
    }

    public String toString() {
        return "Levenshtein [insertDelete=" + this.insertDelete + ", substitute=" + this.substitute + "]";
    }
}

