/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.collect.Multiset;
import org.simmetrics.MultisetDistance;
import org.simmetrics.MultisetMetric;
import org.simmetrics.metrics.Math;

public final class GeneralizedJaccard<T>
implements MultisetMetric<T>,
MultisetDistance<T> {
    @Override
    public float compare(Multiset<T> a, Multiset<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        int intersection = Math.intersection(a, b).size();
        return (float)intersection / (float)(a.size() + b.size() - intersection);
    }

    @Override
    public float distance(Multiset<T> a, Multiset<T> b) {
        return 1.0f - this.compare(a, b);
    }

    public String toString() {
        return "GeneralizedJaccard";
    }
}

