/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Side;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public record DirectionQualifier(EnumSet<Direction> directions) implements ASTNode,
Iterable<Direction>
{
    public static final DirectionQualifier NULL_DIRECTION = new DirectionQualifier(EnumSet.noneOf(Direction.class));
    public static final DirectionQualifier EVERY_DIRECTION = new DirectionQualifier(EnumSet.allOf(Direction.class));

    public static Direction lookup(Side side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Side.TOP -> Direction.UP;
            case Side.BOTTOM -> Direction.DOWN;
            case Side.NORTH -> Direction.NORTH;
            case Side.SOUTH -> Direction.SOUTH;
            case Side.EAST -> Direction.EAST;
            case Side.WEST -> Direction.WEST;
        };
    }

    public static String directionToString(@Nullable Direction direction) {
        if (direction == null) {
            return "";
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> "TOP";
            case Direction.DOWN -> "BOTTOM";
            case Direction.NORTH -> "NORTH";
            case Direction.SOUTH -> "SOUTH";
            case Direction.EAST -> "EAST";
            case Direction.WEST -> "WEST";
        };
    }

    public Stream<Direction> stream() {
        if (this == EVERY_DIRECTION) {
            return Stream.concat(this.directions.stream(), Stream.builder().add(null).build());
        }
        if (this.directions.isEmpty()) {
            return Stream.builder().add(null).build();
        }
        return this.directions.stream();
    }

    @Override
    public Iterator<@Nullable Direction> iterator() {
        if (this == EVERY_DIRECTION) {
            return new SFMDirections.NullableDirectionIterator();
        }
        if (this.directions.isEmpty()) {
            return new SFMDirections.SingleNullDirectionIterator();
        }
        return this.directions.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectionQualifier)) {
            return false;
        }
        DirectionQualifier that = (DirectionQualifier)o;
        return Objects.equals(this.directions, that.directions);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.directions);
    }
}

