/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.config.SFMClientProgramEditorConfig;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.intellisense.IntellisenseAction;
import ca.teamdman.sfml.intellisense.IntellisenseContext;
import ca.teamdman.sfml.intellisense.SFMLIntellisense;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.ListIterator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public class SFMDisplayUtils {
    public static String getCursorPositionDisplay(String programString, int cursorPos) {
        StringBuilder rtn = new StringBuilder();
        rtn.append(" [");
        int start = Math.max(0, cursorPos - 10);
        int end = cursorPos;
        rtn.append(String.format("%20s", programString.substring(start, end).replaceAll("\n", "\\\\n")));
        rtn.append("|");
        start = cursorPos;
        end = Math.min(programString.length(), cursorPos + 10);
        rtn.append(String.format("%-20s", programString.substring(start, end).replaceAll("\n", "\\\\n")));
        rtn.append(" ] ");
        return rtn.toString();
    }

    public static String getCursorTokenDisplay(ProgramBuildResult buildResult, int cursorPos) {
        List tokens = buildResult.metadata().tokens().getTokens();
        List<Token> displayTokens = tokens.stream().filter(token -> token.getStartIndex() - 10 <= cursorPos && token.getStopIndex() + 10 >= cursorPos).toList();
        Token activeToken = buildResult.getTokenAtCursorPosition(cursorPos);
        if (activeToken == null) {
            return "[ COULDN'T FIND CURSOR TOKEN ]";
        }
        StringBuilder inner = new StringBuilder();
        for (Token displayToken : displayTokens) {
            if (displayToken == activeToken) {
                inner.append(">");
            }
            inner.append(displayToken.getText().replaceAll("\n", "\\\\n"));
            if (displayToken == activeToken) {
                inner.append("<");
            }
            inner.append(" ");
        }
        return String.format("[%20s]", inner);
    }

    public static String getTokenHierarchyDisplay(Program program, int cursorPos) {
        StringBuilder rtn = new StringBuilder();
        List<Pair<ASTNode, ParserRuleContext>> nodesUnderCursor = program.astBuilder().getNodesUnderCursor(cursorPos);
        ListIterator<Pair<ASTNode, ParserRuleContext>> iter = nodesUnderCursor.listIterator(nodesUnderCursor.size());
        while (iter.hasPrevious()) {
            Pair<ASTNode, ParserRuleContext> pair = iter.previous();
            ASTNode node = (ASTNode)pair.getFirst();
            rtn.append(node.getClass().getSimpleName());
            if (!iter.hasPrevious()) continue;
            rtn.append(" -> ");
        }
        return rtn.toString();
    }

    public static String getSuggestionsDisplay(ProgramBuildResult programBuildResult, int cursorPos) {
        StringBuilder rtn = new StringBuilder();
        List<IntellisenseAction> suggestions = SFMLIntellisense.getSuggestions(new IntellisenseContext(programBuildResult, cursorPos, 0, LabelPositionHolder.empty(), SFMConfig.getOrFallback(SFMConfig.CLIENT_PROGRAM_EDITOR.intellisenseLevel, SFMClientProgramEditorConfig.IntellisenseLevel.BASIC)));
        rtn.append('[');
        for (int i = 0; i < suggestions.size(); ++i) {
            rtn.append(suggestions.get(i).getComponent().getString().replaceAll("\n", "\\\\n"));
            if (i == suggestions.size() - 1) continue;
            rtn.append(", ");
        }
        rtn.append(']');
        return rtn.toString();
    }
}

