/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.resourcetype.ScalarResourceType;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public abstract class IntegerResourceType<CAP>
extends ScalarResourceType<Integer, CAP> {
    public IntegerResourceType(BlockCapability<CAP, @Nullable Direction> capability, ResourceLocation registryKey) {
        super(capability, registryKey, Integer.class);
    }

    @Override
    public long getAmount(Integer stack) {
        return stack.intValue();
    }

    @Override
    public long getMaxStackSize(Integer integer) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty(Integer stack) {
        return stack == 0;
    }

    @Override
    public Integer getEmptyStack() {
        return 0;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(Integer integer) {
        return Stream.empty();
    }

    @Override
    public Integer copy(Integer integer) {
        return integer;
    }

    @Override
    protected Integer setCount(Integer stack, long amount) {
        return amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
    }

    @Override
    public Integer withCount(Integer integer, long count) {
        return count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }
}

