/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.common.blockentity.IFacadeBlockEntity;
import ca.teamdman.sfm.common.facade.FacadeData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public record FacadePlanAnalysisResult(Map<FacadeData, Integer> facadeDataToCount, Map<Block, Integer> unfacadedCount, Set<BlockPos> positions) {
    public static FacadePlanAnalysisResult analyze(Level level, Set<BlockPos> positions) {
        Object2IntOpenHashMap facadeDataToCount = new Object2IntOpenHashMap();
        Object2IntOpenHashMap unfacadedCount = new Object2IntOpenHashMap();
        for (BlockPos position : positions) {
            BlockEntity blockEntity = level.getBlockEntity(position);
            if (blockEntity instanceof IFacadeBlockEntity) {
                IFacadeBlockEntity blockEntity2 = (IFacadeBlockEntity)blockEntity;
                FacadeData facadeData = blockEntity2.getFacadeData();
                facadeDataToCount.put((Object)facadeData, facadeDataToCount.getInt((Object)facadeData) + 1);
                continue;
            }
            Block block = level.getBlockState(position).getBlock();
            unfacadedCount.put((Object)block, unfacadedCount.getInt((Object)block) + 1);
        }
        return new FacadePlanAnalysisResult((Map<FacadeData, Integer>)facadeDataToCount, (Map<Block, Integer>)unfacadedCount, positions);
    }

    public boolean coversBigArea() {
        Optional bounds = BoundingBox.encapsulatingPositions(this.positions);
        if (bounds.isEmpty()) {
            return false;
        }
        BoundingBox box = (BoundingBox)bounds.get();
        return box.getXSpan() > 8 || box.getYSpan() > 8 || box.getZSpan() > 10;
    }

    public boolean affectingMany() {
        return this.facadeDataToCount.values().stream().mapToInt(i -> i).sum() > 10;
    }

    public boolean affectingManyUnique() {
        return this.facadeDataToCount.keySet().size() > 1;
    }

    public boolean shouldWarn() {
        return this.affectingMany() || this.affectingManyUnique() || this.coversBigArea();
    }

    public int countAffected() {
        return this.facadeDataToCount.values().stream().mapToInt(i -> i).sum() + this.unfacadedCount.values().stream().mapToInt(i -> i).sum();
    }
}

