/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.common.config.SFMClientConfig;
import ca.teamdman.sfm.common.config.SFMClientProgramEditorConfig;
import ca.teamdman.sfm.common.config.SFMServerConfig;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SFMConfig {
    public static final ModConfigSpec SERVER_SPEC;
    public static final SFMServerConfig SERVER;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final SFMClientConfig CLIENT;
    public static final ModConfigSpec CLIENT_PROGRAM_EDITOR_SPEC;
    public static final SFMClientProgramEditorConfig CLIENT_PROGRAM_EDITOR;

    public static <T> T getOrDefault(ModConfigSpec.ConfigValue<T> configValue) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return (T)configValue.getDefault();
        }
    }

    public static <T> T getOrFallback(ModConfigSpec.ConfigValue<T> configValue, T fallback) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        context.getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        context.getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_PROGRAM_EDITOR_SPEC, "sfm-client-program-editor.toml");
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(SFMServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)pair.getRight();
        SERVER = (SFMServerConfig)pair.getLeft();
        pair = new ModConfigSpec.Builder().configure(SFMClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)pair.getRight();
        CLIENT = (SFMClientConfig)pair.getLeft();
        pair = new ModConfigSpec.Builder().configure(SFMClientProgramEditorConfig::new);
        CLIENT_PROGRAM_EDITOR_SPEC = (ModConfigSpec)pair.getRight();
        CLIENT_PROGRAM_EDITOR = (SFMClientProgramEditorConfig)pair.getLeft();
    }
}

