/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.CapabilityCache;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class CableNetwork {
    protected final Level LEVEL;
    protected final LongSet CABLE_POSITIONS = new LongOpenHashSet();
    protected final CapabilityCache CAPABILITY_CACHE = new CapabilityCache();

    public CableNetwork(Level level) {
        this.LEVEL = level;
    }

    public static boolean isCable(@Nullable Level world, @NotStored BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.getBlockState(cablePos).getBlock() instanceof ICableBlock;
    }

    public void rebuildNetwork(@NotStored BlockPos start) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_CACHE.clear();
        CableNetwork.discoverCables(this.getLevel(), start).forEach(this::addCable);
    }

    public void rebuildNetworkFromCache(@NotStored BlockPos start, CableNetwork other) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_CACHE.clear();
        List cables = SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS) {
                target.set((Vec3i)current).move(d);
                if (!other.containsCablePosition((BlockPos)target)) continue;
                next.accept(target.immutable());
            }
        }, start).toList();
        for (BlockPos cablePos : cables) {
            this.CABLE_POSITIONS.add(cablePos.asLong());
        }
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        LongOpenHashSet seenCapabilityPositions = new LongOpenHashSet();
        for (BlockPos cablePos : cables) {
            for (Direction direction : SFMDirections.DIRECTIONS) {
                target.set((Vec3i)cablePos).move(direction);
                boolean firstVisit = seenCapabilityPositions.add(target.asLong());
                if (!firstVisit) continue;
                this.CAPABILITY_CACHE.overwriteFromOther((BlockPos)target, other.CAPABILITY_CACHE);
            }
        }
    }

    public static Stream<BlockPos> discoverCables(Level level, @NotStored BlockPos startPos) {
        return SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS) {
                target.set((Vec3i)current).move(d);
                if (!CableNetwork.isCable(level, (BlockPos)target)) continue;
                next.accept(target.immutable());
            }
        }, startPos);
    }

    public void addCable(@NotStored BlockPos pos) {
        this.CABLE_POSITIONS.add(pos.asLong());
    }

    public Level getLevel() {
        return this.LEVEL;
    }

    public String toString() {
        return "CableNetwork{level=" + String.valueOf(this.getLevel().dimension().location()) + ", #cables=" + this.getCableCount() + ", #cache=" + this.CAPABILITY_CACHE.size() + "}";
    }

    public boolean isAdjacentToCable(@NotStored BlockPos pos) {
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS) {
            target.set((Vec3i)pos).move(direction);
            if (!this.containsCablePosition((BlockPos)target)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCablePosition(@NotStored BlockPos pos) {
        return this.CABLE_POSITIONS.contains(pos.asLong());
    }

    @Nullable
    public <CAP> CAP getCapability(BlockCapability<CAP, @Nullable Direction> capKind, @NotStored BlockPos pos, @Nullable Direction direction, TranslatableLogger logger) {
        Object cap;
        BlockCapabilityCache found = this.CAPABILITY_CACHE.getCapability(pos, capKind, direction);
        if (found != null) {
            cap = found.getCapability();
            if (cap != null) {
                logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT.get(pos, capKind.name(), direction)));
                return (CAP)cap;
            }
            logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT_INVALID.get(pos, capKind.name(), direction)));
        } else {
            logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_MISS.get(pos, capKind.name(), direction)));
        }
        if (!this.isAdjacentToCable(pos)) {
            logger.warn(x -> x.accept(LocalizationKeys.LOGS_MISSING_ADJACENT_CABLE.get(pos)));
            return null;
        }
        cap = this.getLevel().getCapability(capKind, pos, (Object)direction);
        if (cap != null) {
            Level level = this.getLevel();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            found = BlockCapabilityCache.create(capKind, (ServerLevel)serverLevel, (BlockPos)pos, (Object)direction, () -> true, () -> this.CAPABILITY_CACHE.remove(pos, capKind, direction));
            this.CAPABILITY_CACHE.putCapability(pos, capKind, direction, found);
        } else {
            logger.warn(x -> x.accept(LocalizationKeys.LOGS_EMPTY_CAPABILITY.get(pos, capKind.name(), direction)));
        }
        return (CAP)cap;
    }

    public int getCableCount() {
        return this.CABLE_POSITIONS.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLE_POSITIONS.addAll((LongCollection)other.CABLE_POSITIONS);
        this.CAPABILITY_CACHE.putAll(other.CAPABILITY_CACHE);
    }

    public boolean isEmpty() {
        return this.CABLE_POSITIONS.isEmpty();
    }

    public Stream<BlockPos> getCablePositions() {
        return this.CABLE_POSITIONS.longStream().mapToObj(BlockPos::of);
    }

    public LongSet getCablePositionsRaw() {
        return this.CABLE_POSITIONS;
    }

    public Stream<BlockPos> getCapabilityProviderPositions() {
        return this.CAPABILITY_CACHE.getPositions();
    }

    public void bustCacheForChunk(ChunkAccess chunkAccess) {
        this.CAPABILITY_CACHE.bustCacheForChunk(chunkAccess);
    }

    protected List<CableNetwork> withoutCable(@NotStored BlockPos cablePos) {
        this.CABLE_POSITIONS.remove(cablePos.asLong());
        ArrayList<CableNetwork> branches = new ArrayList<CableNetwork>();
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS) {
            target.set((Vec3i)cablePos).move(direction);
            if (!this.containsCablePosition((BlockPos)target) || branches.stream().anyMatch(n -> n.containsCablePosition((BlockPos)target))) continue;
            CableNetwork branchNetwork = new CableNetwork(this.getLevel());
            branchNetwork.rebuildNetworkFromCache((BlockPos)target, this);
            branches.add(branchNetwork);
        }
        return branches;
    }
}

