/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.ClientKeyHelpers;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.net.ServerboundLabelGunCycleViewModePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUpdatePacket;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMHandUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class LabelGunKeyMappingHandler {
    private static AltState altState = AltState.Idle;
    private static boolean labelSwitchKeyDown = false;

    public static void setExternalDebounce() {
        altState = AltState.PressCancelledExternally;
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        LabelGunKeyMappingHandler.handleAltKeyLogic();
        LabelGunKeyMappingHandler.handleLabelSwitchKeyLogic((Player)player);
    }

    private static void handleLabelSwitchKeyLogic(Player player) {
        boolean nextLabelKeyDown = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_NEXT_LABEL_KEY);
        boolean prevLabelKeyDown = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_PREVIOUS_LABEL_KEY);
        boolean justPressed = !labelSwitchKeyDown && (nextLabelKeyDown || prevLabelKeyDown);
        boolean bl = labelSwitchKeyDown = nextLabelKeyDown || prevLabelKeyDown;
        if (justPressed) {
            SFMHandUtils.ItemStackInHand labelGun = SFMHandUtils.getItemAndHand(player, SFMItems.LABEL_GUN_ITEM.get());
            if (labelGun == null) {
                return;
            }
            String nextLabel = LabelGunItem.getNextLabel(labelGun.stack(), prevLabelKeyDown ? -1 : 1);
            SFMPackets.sendToServer(new ServerboundLabelGunUpdatePacket(nextLabel, labelGun.hand()));
        }
    }

    private static void handleAltKeyLogic() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen != null) {
            return;
        }
        boolean alt_down = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.CYCLE_LABEL_VIEW_KEY);
        switch (altState.ordinal()) {
            case 0: {
                if (!alt_down) break;
                altState = AltState.Pressed;
                break;
            }
            case 1: {
                if (alt_down) break;
                altState = AltState.Idle;
                assert (minecraft.player != null);
                InteractionHand hand = SFMHandUtils.getHandHoldingItem((Player)minecraft.player, SFMItems.LABEL_GUN_ITEM.get());
                if (hand == null) {
                    return;
                }
                SFMPackets.sendToServer(new ServerboundLabelGunCycleViewModePacket(hand));
                break;
            }
            case 2: {
                if (alt_down) break;
                altState = AltState.Idle;
            }
        }
    }

    private static enum AltState {
        Idle,
        Pressed,
        PressCancelledExternally;

    }
}

