/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.gui.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.gui.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunClearPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunCycleViewModePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunPrunePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUpdatePacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMPackets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class LabelGunScreen
extends Screen {
    private final InteractionHand HAND;
    private final LabelPositionHolder LABEL_HOLDER;
    private final ArrayList<Button> labelButtons = new ArrayList();
    private EditBox labelField;
    private boolean shouldRebuildWidgets = false;

    public LabelGunScreen(ItemStack labelGunStack, InteractionHand hand) {
        super((Component)LocalizationKeys.LABEL_GUN_GUI_TITLE.getComponent());
        this.LABEL_HOLDER = LabelPositionHolder.from(labelGunStack);
        this.HAND = hand;
    }

    protected void init() {
        super.init();
        SFMScreenRenderUtils.enableKeyRepeating();
        this.labelField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)LocalizationKeys.LABEL_GUN_GUI_LABEL_PLACEHOLDER.getComponent()));
        this.labelField.setResponder(this::onTextUpdated);
        this.labelField.setSuggestion(LocalizationKeys.LABEL_GUN_GUI_LABEL_EDIT_PLACEHOLDER.getString());
        this.setInitialFocus((GuiEventListener)this.labelField);
        this.setFocused((GuiEventListener)this.labelField);
        this.labelField.setFocused(true);
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setSize(50, 20).setPosition(this.width / 2 - 210, 50).setText(LocalizationKeys.LABEL_GUN_GUI_CLEAR_BUTTON).setOnPress(btn -> {
            SFMPackets.sendToServer(new ServerboundLabelGunClearPacket(this.HAND));
            this.LABEL_HOLDER.clear();
            this.shouldRebuildWidgets = true;
        }).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setSize(50, 20).setPosition(this.width / 2 + 160, 50).setText(LocalizationKeys.LABEL_GUN_GUI_PRUNE_BUTTON).setOnPress(btn -> {
            SFMPackets.sendToServer(new ServerboundLabelGunPrunePacket(this.HAND));
            this.LABEL_HOLDER.prune();
            this.shouldRebuildWidgets = true;
        }).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setSize(200, 20).setPosition(this.width / 2 - 2 - 100, this.height - 25).setText(LocalizationKeys.LABEL_GUN_GUI_CYCLE_VIEW_BUTTON).setOnPress(btn -> {
            SFMPackets.sendToServer(new ServerboundLabelGunCycleViewModePacket(this.HAND));
            this.onClose();
        }).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setSize(300, 20).setPosition(this.width / 2 - 2 - 150, this.height - 50).setText(CommonComponents.GUI_DONE).setOnPress(p_97691_ -> this.onDone()).build());
        this.onTextUpdated("");
    }

    public boolean keyPressed(int key, int mod1, int mod2) {
        if (super.keyPressed(key, mod1, mod2)) {
            return true;
        }
        if (key != 257 && key != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public void onDone() {
        SFMPackets.sendToServer(new ServerboundLabelGunUpdatePacket(this.labelField.getValue(), this.HAND));
        this.onClose();
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.labelField.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.labelField.setValue(prev);
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        if (this.shouldRebuildWidgets) {
            this.shouldRebuildWidgets = false;
            this.rebuildWidgets();
        }
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
    }

    private void onTextUpdated(String newText) {
        this.labelField.setSuggestion(newText.isEmpty() ? LocalizationKeys.LABEL_GUN_GUI_LABEL_EDIT_PLACEHOLDER.getString() : "");
        this.labelButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.labelButtons.clear();
        int buttonWidth = this.LABEL_HOLDER.labels().entrySet().stream().map(entry -> LocalizationKeys.LABEL_GUN_GUI_LABEL_BUTTON.getComponent(entry.getKey(), ((HashSet)entry.getValue()).size()).getString()).mapToInt(arg_0 -> ((Font)this.font).width(arg_0)).max().orElse(50) + 10;
        int paddingX = 5;
        int paddingY = 5;
        int buttonHeight = 20;
        int buttonsPerRow = this.width / (buttonWidth + paddingX);
        int i = 0;
        List<String> labels = this.LABEL_HOLDER.labels().keySet().stream().filter(text -> text.toLowerCase().contains(newText.toLowerCase())).sorted(Comparator.naturalOrder()).toList();
        for (String label : labels) {
            int x = (this.width - (buttonWidth + paddingX) * Math.min(buttonsPerRow, labels.size())) / 2 + paddingX + i % buttonsPerRow * (buttonWidth + paddingX);
            int y = 80 + i / buttonsPerRow * (buttonHeight + paddingY);
            this.addLabelButton(label, x, y, buttonWidth, buttonHeight);
            ++i;
        }
    }

    private void addLabelButton(String label, int x, int y, int width, int height) {
        int count = this.LABEL_HOLDER.getPositions(label).size();
        Button button = new SFMButtonBuilder().setSize(width, height).setPosition(x, y).setText((Component)LocalizationKeys.LABEL_GUN_GUI_LABEL_BUTTON.getComponent(label, count)).setOnPress(btn -> {
            this.labelField.setValue(label);
            this.onDone();
        }).build();
        this.labelButtons.add(button);
        this.addRenderableWidget((GuiEventListener)button);
    }
}

