/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.gui.screen.SFMFontUtils;
import ca.teamdman.sfm.client.gui.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class ExamplesScreen
extends Screen {
    private final BiConsumer<String, Map<String, String>> CALLBACK;

    public ExamplesScreen(BiConsumer<String, Map<String, String>> callback) {
        super((Component)LocalizationKeys.EXAMPLES_GUI_TITLE.getComponent());
        this.CALLBACK = callback;
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTransparentBackground(graphics);
        this.renderTransparentBackground(graphics);
        this.renderTransparentBackground(graphics);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        MutableComponent warning1 = LocalizationKeys.EXAMPLES_GUI_WARNING_1.getComponent();
        SFMFontUtils.draw(graphics, this.font, (Component)warning1, this.width / 2 - this.font.width((FormattedText)warning1) / 2, 20, 0xFFFFFF, false);
        MutableComponent warning2 = LocalizationKeys.EXAMPLES_GUI_WARNING_2.getComponent();
        SFMFontUtils.draw(graphics, this.font, (Component)warning2, this.width / 2 - this.font.width((FormattedText)warning2) / 2, 36, 0xFFFFFF, false);
    }

    protected void init() {
        super.init();
        ResourceManager irm = Minecraft.getInstance().getResourceManager();
        Map found = irm.listResources("template_programs", path -> path.getPath().endsWith(".sfml") || path.getPath().endsWith(".sfm"));
        HashMap templatePrograms = new HashMap();
        for (Map.Entry entry : found.entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    String programString = reader.lines().collect(Collectors.joining("\n"));
                    if (programString.contains("$REPLACE_RESOURCE_TYPES_HERE$")) {
                        List<? extends String> disallowedResourceTypesForTransfer = SFMConfig.getOrDefault(SFMConfig.SERVER.disallowedResourceTypesForTransfer);
                        String replacement = SFMResourceTypes.registry().keySet().stream().map(ResourceLocation::getPath).map(e -> {
                            Object text = "";
                            if (disallowedResourceTypesForTransfer.contains(e)) {
                                text = (String)text + "-- (disallowed in config) ";
                            }
                            text = (String)text + "INPUT " + e + ":: FROM a";
                            return text;
                        }).collect(Collectors.joining("\n    "));
                        programString = programString.replace("$REPLACE_RESOURCE_TYPES_HERE$", replacement);
                    }
                    String finalProgram = programString;
                    ProgramBuilder.build(programString).caseSuccess((program, metadata) -> templatePrograms.put(program.name().isBlank() ? ((ResourceLocation)entry.getKey()).toString() : program.name(), finalProgram)).caseFailure(result -> templatePrograms.put(String.format("(compile failed) %s", ((ResourceLocation)entry.getKey()).toString()), finalProgram));
                    Program.compile(programString, successProgram -> templatePrograms.put(successProgram.name().isBlank() ? ((ResourceLocation)entry.getKey()).toString() : successProgram.name(), finalProgram), failure -> templatePrograms.put(String.format("(compile failed) %s", ((ResourceLocation)entry.getKey()).toString()), finalProgram));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException reader) {}
        }
        int i = 0;
        int buttonWidth = templatePrograms.keySet().stream().mapToInt(arg_0 -> ((Font)this.font).width(arg_0)).max().orElse(50) + 10;
        int buttonHeight = 20;
        int paddingX = 5;
        int paddingY = 5;
        int buttonsPerRow = this.width / (buttonWidth + paddingX);
        for (Map.Entry entry : templatePrograms.entrySet().stream().sorted((o1, o2) -> Comparator.naturalOrder().compare((String)o1.getKey(), (String)o2.getKey())).toList()) {
            int x = (this.width - (buttonWidth + paddingX) * Math.min(buttonsPerRow, templatePrograms.size())) / 2 + paddingX + i % buttonsPerRow * (buttonWidth + paddingX);
            int y = 50 + i / buttonsPerRow * (buttonHeight + paddingY);
            this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setText((Component)Component.literal((String)((String)entry.getKey()))).setOnPress(btn -> {
                this.onClose();
                this.CALLBACK.accept((String)entry.getValue(), templatePrograms);
            }).setPosition(x, y).setSize(buttonWidth, buttonHeight).build());
            ++i;
        }
    }
}

