/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.EndRemasteredCompat;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.mixin.client.GameRendererAccessor;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static final int BREATH_DELAY = 60;
    public static final int SNORE_DELAY = 10;
    public static final int MAX_Z_COUNT = 3;
    public static final DustParticleOptions GLOWSTONE_DUST_PARTICLES = new DustParticleOptions(Vec3.fromRGB24((int)16759902).toVector3f(), 1.0f);
    public static final ResourceLocation COLORLESS_RAIN_TEXTURE = SubtleEffects.loc("textures/environment/colorless_rain.png");
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation VANILLA_EYE = ResourceLocation.withDefaultNamespace((String)"ender_eye");

    public static void playClientSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null && level.isClientSide) {
            level.playSound((Player)minecraft.player, entity, sound, source, volume, pitch);
        }
    }

    public static void playClientSound(BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null && level.isClientSide) {
            level.playSound((Player)minecraft.player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), sound, source, volume, pitch);
        }
    }

    public static boolean isSolidOrNotEmpty(Level level, BlockPos pos) {
        return level.getBlockState(pos).isSolidRender((BlockGetter)level, pos) || !level.getFluidState(pos).isEmpty();
    }

    public static int getLightColor(int superLight) {
        return 0xF0 | superLight >> 16 & 0xFF0000;
    }

    public static void applyHelmetShader(ItemStack stack, CameraType cameraType) {
        if (!cameraType.isFirstPerson()) {
            return;
        }
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        for (MobSkullShaderData shaderData : MobSkullShaderReloadListener.MOB_SKULL_SHADERS.values()) {
            if (!shaderData.stackHolder().matches(stack)) continue;
            Util.loadShaderEffect(shaderData.shaderId(), gameRenderer);
            return;
        }
        gameRenderer.shutdownEffect();
    }

    private static void loadShaderEffect(ResourceLocation shaderId, GameRenderer gameRenderer) {
        PostChain effect = gameRenderer.currentEffect();
        if (effect == null || !effect.getName().equals(shaderId.toString())) {
            ((GameRendererAccessor)gameRenderer).loadShaderEffect(shaderId);
        }
    }

    public static void setColorFromHex(Particle particle, int hexColor) {
        particle.setColor((float)(hexColor >> 16) / 255.0f, (float)(hexColor >> 8) / 255.0f, (float)hexColor / 255.0f);
    }

    public static boolean isChunkLoaded(Level level, double blockX, double blockZ) {
        return level.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((double)blockX), SectionPos.blockToSectionCoord((double)blockZ));
    }

    public static double getCauldronFillHeight(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock block2 = (AbstractCauldronBlock)block;
            return ((AbstractCauldronBlockAccessor)block2).getFillHeight(state);
        }
        return 0.0;
    }

    public static Fluid getCauldronFluid(BlockState state) {
        if (state.is(Blocks.LAVA_CAULDRON)) {
            return Fluids.LAVA;
        }
        if (state.is(Blocks.WATER_CAULDRON)) {
            return Fluids.WATER;
        }
        return Fluids.EMPTY;
    }

    public static ValidatedColor.ColorHolder getEyeColorHolder(Level level, BlockPos pos) {
        ValidatedColor.ColorHolder color;
        if (CompatHelper.IS_END_REMASTERED_LOADED.get().booleanValue() && (color = EndRemasteredCompat.getEyeColor(level, pos)) != null) {
            return color;
        }
        ValidatedColor.ColorHolder vanillaColor = (ValidatedColor.ColorHolder)ModConfigs.BLOCKS.eyeColors.get((Object)VANILLA_EYE);
        if (vanillaColor != null) {
            return vanillaColor;
        }
        return Util.toColorHolder(0x7ABAAB);
    }

    public static ValidatedColor.ColorHolder toColorHolder(int color) {
        return new ValidatedColor.ColorHolder(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255, false);
    }
}

