/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers.entity_tickers;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.ItemBordersCompat;
import einstein.subtle_effects.configs.entities.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.tickers.entity_tickers.EntityTicker;
import einstein.subtle_effects.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIngredient;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.dimension.DimensionType;

public class ItemRarityTicker
extends EntityTicker<ItemEntity> {
    private static final TextColor WHITE_TEXT = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);
    private static final TagKey<DimensionType> DIMENSIONS = TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)SubtleEffects.loc("no_item_rarities"));
    private final List<TextColor> nameColors = new ArrayList<TextColor>();
    private final ItemStack stack = ((ItemEntity)this.entity).getItem();
    private final boolean isCommon = this.stack.getRarity() == Rarity.COMMON;

    public ItemRarityTicker(ItemEntity entity) {
        super(entity, true);
        this.getItemNameColors();
        if (this.isCommon && ModConfigs.ENTITIES.itemRarity.particlesDisplayType == ItemRarityConfigs.DisplayType.NOT_COMMON && this.nameColors.size() == 1 && this.nameColors.getFirst().equals((Object)WHITE_TEXT)) {
            this.nameColors.clear();
        }
    }

    private void getItemNameColors() {
        TextColor rarityColor;
        if (this.level.dimensionTypeRegistration().is(DIMENSIONS)) {
            return;
        }
        if (!ModConfigs.ENTITIES.itemRarity.colorOverrides.isEmpty()) {
            for (Map.Entry entry : ModConfigs.ENTITIES.itemRarity.colorOverrides.entrySet()) {
                if (!((ValidatedIngredient.IngredientProvider)entry.getKey()).provide().test(this.stack)) continue;
                this.nameColors.add(TextColor.fromRgb((int)((ValidatedColor.ColorHolder)entry.getValue()).argb()));
                if (ModConfigs.ENTITIES.itemRarity.mixedColorName) continue;
                break;
            }
            if (ModConfigs.ENTITIES.itemRarity.particleColorType == ItemRarityConfigs.ParticleColorType.ONLY_COLOR_OVERRIDES) {
                return;
            }
        }
        if (ModConfigs.ENTITIES.itemRarity.particleColorType == ItemRarityConfigs.ParticleColorType.NAME_COLOR) {
            boolean usesSingleColor;
            Component hoverName = this.stack.getHoverName();
            TextColor baseColor = hoverName.getStyle().getColor();
            ArrayList<TextColor> colors = new ArrayList<TextColor>(hoverName.getSiblings().stream().map(component -> component.getStyle().getColor()).filter(Objects::nonNull).toList());
            boolean bl = usesSingleColor = colors.isEmpty() || !ModConfigs.ENTITIES.itemRarity.mixedColorName;
            if (baseColor != null) {
                colors.add(baseColor);
            }
            if (usesSingleColor) {
                TextColor color;
                Object object = baseColor != null ? baseColor : (color = !colors.isEmpty() ? (TextColor)colors.getFirst() : null);
                if (!(color == null || this.isCommon && color.equals((Object)WHITE_TEXT))) {
                    this.nameColors.add(color);
                    return;
                }
            } else {
                this.nameColors.addAll(colors);
                return;
            }
        }
        if (ModConfigs.ENTITIES.itemRarity.useItemBorder && CompatHelper.IS_ITEM_BORDERS_LOADED.get().booleanValue()) {
            TextColor borderColor = ItemBordersCompat.getManualBorderColor(this.level, this.stack);
            if (borderColor != null) {
                this.nameColors.add(borderColor);
                return;
            }
            List<TextColor> componentColors = ItemBordersCompat.getNBTBorderColor(this.stack);
            if (!componentColors.isEmpty()) {
                this.nameColors.addAll(componentColors);
                return;
            }
        }
        if ((rarityColor = Services.PARTICLE_HELPER.getRarityColor(this.stack.getRarity())) != null) {
            this.nameColors.add(rarityColor);
            return;
        }
        SubtleEffects.LOGGER.warn("Failed to get item display name color for item: {}", (Object)this.stack.getDisplayName());
        this.nameColors.add(WHITE_TEXT);
    }

    @Override
    public void entityTick() {
        if (this.nameColors.isEmpty()) {
            return;
        }
        if (ModEntityTickers.shouldSpawn(this.random, ModConfigs.ENTITIES.itemRarity.particleDensity)) {
            this.level.addParticle((ParticleOptions)new IntegerParticleOptions(ModParticles.ITEM_RARITY.get(), (this.nameColors.size() > 1 ? this.nameColors.get(this.random.nextInt(this.nameColors.size())) : this.nameColors.getFirst()).getValue()), ((ItemEntity)this.entity).getRandomX(1.0), ((ItemEntity)this.entity).getY(), ((ItemEntity)this.entity).getRandomZ(1.0), 0.0, MathUtil.nextDouble(this.random, 0.02), 0.0);
        }
    }
}

