/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FlameGeyserTicker
extends Ticker {
    public static final List<BlockPos> ACTIVE_GEYSERS = new ArrayList<BlockPos>();
    public static final List<BlockPos> INACTIVE_GEYSERS = new ArrayList<BlockPos>();
    public static final List<Block> VALID_BLOCKS = List.of(Blocks.NETHERRACK, Blocks.BLACKSTONE, Blocks.SOUL_SOIL);
    private final ParticleOptions particle;
    private final Level level;
    private final BlockPos pos;
    private final RandomSource random;
    private final int lifeTime;
    private int age;

    public FlameGeyserTicker(Level level, BlockPos pos, RandomSource random) {
        this.level = level;
        this.pos = pos;
        this.random = random;
        this.particle = level.getBiome(pos).is(Biomes.SOUL_SAND_VALLEY) ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
        this.lifeTime = this.getTickDelay((Integer)ModConfigs.ENVIRONMENT.flameGeyserActiveTime.get());
        ACTIVE_GEYSERS.add(pos);
    }

    @Override
    public void tick() {
        ++this.age;
        if (this.age >= this.lifeTime) {
            this.remove();
            return;
        }
        if (Util.isChunkLoaded(this.level, this.pos.getX(), this.pos.getZ()) && FlameGeyserTicker.checkLocation(this.level, this.pos, false)) {
            if (this.age == 1) {
                this.level.addParticle((ParticleOptions)new IntegerParticleOptions(ModParticles.GEYSER_HOLE.get(), this.lifeTime), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.001, (double)this.pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
            if (this.age % 5 == 0) {
                Util.playClientSound(this.pos, ModSounds.GEYSER_WHOOSH.get(), SoundSource.BLOCKS, ((Float)ModConfigs.ENVIRONMENT.flameGeyserSoundVolume.get()).floatValue(), this.random.nextFloat() * 0.7f + 0.3f);
            }
            for (int i = 0; i < 10; ++i) {
                this.level.addParticle(this.particle, (double)this.pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(this.random, 0.1), (double)this.pos.getY() + 1.0625, (double)this.pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(this.random, 0.1), MathUtil.nextNonAbsDouble(this.random, 0.01, 0.05), Mth.nextDouble((RandomSource)this.random, (double)0.3, (double)0.35), MathUtil.nextNonAbsDouble(this.random, 0.01, 0.05));
            }
            return;
        }
        this.remove();
    }

    public static boolean checkLocation(Level level, BlockPos pos, boolean checkAbove) {
        BlockPos abovePos;
        if (VALID_BLOCKS.contains(level.getBlockState(pos).getBlock()) && FlameGeyserTicker.isNotFaceSturdyOrFluidEmpty(level, abovePos = pos.above())) {
            if (checkAbove) {
                for (int i = 1; i < 5; ++i) {
                    if (FlameGeyserTicker.isNotFaceSturdyOrFluidEmpty(level, abovePos.relative(Direction.UP, i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isNotFaceSturdyOrFluidEmpty(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return !state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN) && !(state.getBlock() instanceof BaseFireBlock) && level.getFluidState(pos).isEmpty();
    }

    @Override
    public void remove() {
        super.remove();
        ACTIVE_GEYSERS.remove(this.pos);
        INACTIVE_GEYSERS.add(this.pos);
        TickerManager.schedule(this.getTickDelay((Integer)ModConfigs.ENVIRONMENT.flameGeyserInactiveTime.get()), () -> INACTIVE_GEYSERS.remove(this.pos));
    }

    private int getTickDelay(int max) {
        return max >= 300 ? Mth.nextInt((RandomSource)this.random, (int)(max - 200), (int)max) : max;
    }
}

