/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.BaseAnimatedParticle;
import einstein.subtle_effects.particle.ParticleAnimation;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class FireflyParticle
extends BaseAnimatedParticle {
    private int xTicks;
    private int xTicksMax;
    private int waitTicksMax;
    private int waitTicks;
    private boolean isMovingUp;
    private int yTicks;
    private int zTicks;
    private int zTicksMax;

    public FireflyParticle(ClientLevel level, ParticleAnimation animation, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0, animation);
        this.xTicksMax = this.random.nextInt(60);
        this.waitTicks = this.waitTicksMax = this.random.nextInt(20, 40);
        this.yTicks = 20;
        this.zTicksMax = this.random.nextInt(60);
        this.setSize(0.02f, 0.02f);
        this.hasPhysics = true;
        this.friction = 1.0f;
        this.gravity = 0.0f;
        this.quadSize = 0.3f;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.removed) {
            return;
        }
        if (this.x == this.xo || this.onGround || this.z == this.zo) {
            this.remove();
            return;
        }
        ++this.xTicks;
        if (this.xTicks >= this.xTicksMax) {
            this.xTicks = 0;
            this.xTicksMax = this.random.nextInt(60);
            this.xd = MathUtil.nextNonAbsDouble(this.random, 0.1);
        }
        ++this.waitTicks;
        if (this.waitTicks >= this.waitTicksMax) {
            if (!this.isMovingUp) {
                this.yd = MathUtil.nextNonAbsDouble(this.random, 0.05);
                this.isMovingUp = true;
            }
            --this.yTicks;
            if (this.yTicks <= 0) {
                this.isMovingUp = false;
                this.yd = 0.0;
                this.yTicks = 0;
                this.waitTicks = 0;
                this.waitTicksMax = this.random.nextInt(20, 40);
            }
        }
        ++this.zTicks;
        if (this.zTicks >= this.zTicksMax) {
            this.zTicks = 0;
            this.zTicksMax = this.random.nextInt(60);
            this.zd = MathUtil.nextNonAbsDouble(this.random, 0.1);
        }
    }

    public int getLightColor(float partialTick) {
        return Util.getLightColor(super.getLightColor(partialTick));
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        @NotNull
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FireflyParticle(level, new ParticleAnimation(this.sprites, 16, 3), x, y, z);
        }
    }
}

