/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.configs;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.Util;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigGroup;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;

@Translation(prefix="config.subtle_effects.general")
public class ModGeneralConfigs
extends Config {
    public ConfigGroup particleRenderingGroup = new ConfigGroup("particle_rendering");
    public boolean enableParticleCulling = true;
    @ValidatedInt.Restrict(min=1, max=32)
    public int particleRenderDistance = 5;
    @ConfigGroup.Pop
    public boolean cullParticlesInUnloadedChunks = true;
    public ConfigGroup particlesGroup = new ConfigGroup("particles");
    public ConfigGroup dripParticlesGroup = new ConfigGroup("particles.drip_particles");
    public boolean glowingLavaDrops = true;
    public boolean fluidDropsEvaporate = true;
    public ValidatedFloat fluidDropsEvaporationVolume = new ValidatedFloat(0.25f, 1.0f, 0.0f);
    public boolean dropLandInFluidSplashes = true;
    @ConfigGroup.Pop
    public boolean dropLandSounds = true;
    public boolean lavaSparkSmoke = true;
    public ValidatedFloat sparksScale = new ValidatedFloat(1.0f, 2.0f, 1.0f);
    public boolean poppingHearts = true;
    public boolean poppingBubbles = true;
    @ConfigGroup.Pop
    public ValidatedFloat poppingBubblesVolume = new ValidatedFloat(0.2f, 1.0f, 0.0f);
    public boolean mobSkullShaders = true;
    public ValidatedFloat fireHeight = new ValidatedFloat(-0.15f, 0.4f, -0.5f);
    public boolean nightVisionFading = true;
    public boolean enableEasterEggs = true;

    public ModGeneralConfigs() {
        super(SubtleEffects.loc("general"));
    }

    public void onUpdateClient() {
        Minecraft minecraft = Minecraft.getInstance();
        TickerManager.clear((Level)Minecraft.getInstance().level);
        if (minecraft.level != null && minecraft.options.getCameraType().isFirstPerson()) {
            if (!this.mobSkullShaders) {
                minecraft.gameRenderer.shutdownEffect();
                return;
            }
            LocalPlayer player = minecraft.player;
            if (player != null) {
                Util.applyHelmetShader(player.getInventory().getArmor(3), minecraft.options.getCameraType());
            }
        }
    }
}

