/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.config.ConversionRegistry;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackTagMatcher
extends ItemStackMatcher {
    private List<ItemStack> tagMatches;

    public ItemStackTagMatcher(ItemStack stack) {
        super(stack);
        this.refreshTagMatches();
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)stack)) {
            if (this.tagMatches == null) {
                return false;
            }
            if (this.stack.getItem() == stack.getItem()) {
                return false;
            }
            boolean tagMatch = false;
            for (ItemStack tagStack : this.tagMatches) {
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)tagStack)) continue;
                tagMatch = true;
                break;
            }
            return tagMatch;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack);
    }

    public void refreshTagMatches() {
        if (this.stack.isEmpty()) {
            this.tagMatches = null;
            return;
        }
        this.tagMatches = ConversionRegistry.INSTANCE.getEquivItems(this.stack.getItem());
        List tags = this.stack.getTags().toList();
        for (TagKey tag : tags) {
            if (!ConversionRegistry.INSTANCE.isEntryValid((TagKey<Item>)tag)) continue;
            BuiltInRegistries.ITEM.getOrCreateTag(tag).stream().forEach(e -> this.tagMatches.add(new ItemStack(e)));
        }
        if (this.tagMatches.isEmpty()) {
            this.tagMatches = null;
        }
    }
}

