/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.components.item.KeyringContents;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.KeyringTooltip;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemKeyring
extends Item {
    private static final String TAG_ITEMS = "Items";
    private final RegistryEntry<? extends ItemKey> key;

    public ItemKeyring(RegistryEntry<? extends ItemKey> key, Item.Properties properties) {
        super(properties);
        this.key = key;
    }

    public ItemStack getKey() {
        if (this.key == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.key.get(), 1);
    }

    public boolean overrideOtherStackedOnMe(ItemStack targetStack, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        ItemStack newStack;
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (targetStack.getCount() != 1) {
            return false;
        }
        KeyringContents contents = (KeyringContents)targetStack.getOrDefault((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get(), (Object)KeyringContents.EMPTY);
        KeyringContents.Mutable mutable = new KeyringContents.Mutable(contents);
        if (stack.isEmpty()) {
            ItemStack removed = mutable.removeOne();
            if (removed != null) {
                access.set(removed);
                contents = mutable.toImmutable();
                targetStack.set((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get(), (Object)contents);
            }
            if (ItemKeyring.getContents(targetStack).findAny().isEmpty()) {
                ItemStack newStack2 = new ItemStack((ItemLike)ModItems.KEYRING.get(), 1);
                newStack2.applyComponents(targetStack.getComponentsPatch());
                slot.set(newStack2);
            } else {
                ItemStack newStack3 = this.rotateKeyring(targetStack);
                slot.set(newStack3);
            }
            return true;
        }
        mutable.tryInsert(stack);
        contents = mutable.toImmutable();
        targetStack.set((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get(), (Object)contents);
        if (targetStack.getItem() == ModItems.KEYRING.get() && contents.size() > 0 && !(newStack = ItemKeyring.getKeyring(contents.itemCopyStream().findFirst().orElse(ItemStack.EMPTY))).isEmpty()) {
            newStack.set((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get(), (Object)contents);
            slot.set(newStack);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        List<ItemStack> list = ItemKeyring.getContents(stack).toList();
        if (list.isEmpty()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ItemStack keyring = this.rotateKeyring(stack);
        return InteractionResultHolder.success((Object)keyring);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (this.key != null) {
            return ((ItemKey)((Object)this.key.get())).useOn(context);
        }
        return InteractionResult.PASS;
    }

    public static ItemStack getKeyring(ItemStack item) {
        if (item.isEmpty() || !(item.getItem() instanceof ItemKey)) {
            return ItemStack.EMPTY;
        }
        Optional<ItemKeyring> keyring = ModItems.getKeyrings().filter(s -> s.getKey().getItem() == item.getItem()).findFirst();
        if (!keyring.isPresent()) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)keyring.get(), 1);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(DataComponents.HIDE_TOOLTIP) || stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable((KeyringContents)stack.get((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get())).map(KeyringTooltip::new);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag advanced) {
        ComponentUtil.appendSplitDescription(list, this);
    }

    public Component getName(ItemStack stack) {
        if (this.key == null || this.key.get() == null) {
            return super.getName(stack);
        }
        ItemStack activeKey = ItemKeyring.getActiveKey(stack, (Item)this.key.get());
        Object subName = activeKey != null ? activeKey.getHoverName() : Component.translatable((String)((ItemKey)((Object)this.key.get())).getDescriptionId());
        MutableComponent name = Component.translatable((String)((ItemKeyring)((Object)ModItems.KEYRING.get())).getDescriptionId());
        return name.append(" (").append(subName).append(")");
    }

    @NotNull
    public Component getDescription() {
        return Component.translatable((String)(((ItemKeyring)((Object)ModItems.KEYRING.get())).getDescriptionId() + ".desc"));
    }

    public void onDestroyed(ItemEntity entity) {
        KeyringContents contents = (KeyringContents)entity.getItem().get((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents != null) {
            entity.getItem().set((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get(), (Object)KeyringContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)entity, contents.itemsCopy());
        }
    }

    private static ItemStack getActiveKey(ItemStack stack, Item item) {
        KeyringContents contents = (KeyringContents)stack.get((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents == null || contents.size() == 0) {
            return null;
        }
        return contents.itemCopyStream().filter(t -> ItemStack.isSameItem((ItemStack)t, (ItemStack)new ItemStack((ItemLike)item))).findFirst().orElse(null);
    }

    private static Stream<ItemStack> getContents(ItemStack stack) {
        KeyringContents contents = (KeyringContents)stack.get((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents == null || contents.size() == 0) {
            return Stream.empty();
        }
        return contents.itemCopyStream();
    }

    private ItemStack rotateKeyring(ItemStack stack) {
        List<ItemStack> list = ItemKeyring.getContents(stack).toList();
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getItem() != this.key.get()) continue;
            index = i;
            break;
        }
        if (++index >= list.size()) {
            index = 0;
        }
        ItemStack nextItem = list.get(index);
        ItemStack keyring = ItemKeyring.getKeyring(nextItem);
        keyring.applyComponents(stack.getComponentsPatch());
        return keyring;
    }
}

