/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddUpgradeRecipe
extends CustomRecipe {
    public AddUpgradeRecipe(CraftingBookCategory cat) {
        super(cat);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        return this.findContext(inv, (HolderLookup.Provider)world.registryAccess()) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, HolderLookup.Provider registries) {
        Context ctx = this.findContext(inv, registries);
        if (ctx == null) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = ctx.drawer.copy();
        CustomData blockData = (CustomData)ret.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blockData != null) {
            CustomData data = CustomData.of((CompoundTag)ctx.data.write(registries, blockData.copyTag()));
            ret.set(DataComponents.BLOCK_ENTITY_DATA, (Object)data);
            return ret;
        }
        CustomData upgradeData = (CustomData)ret.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CustomData data = CustomData.of((CompoundTag)ctx.data.write(registries, upgradeData.copyTag()));
        ret.set(DataComponents.CUSTOM_DATA, (Object)data);
        return ret;
    }

    @Nullable
    private Context findContext(CraftingInput inv, HolderLookup.Provider registries) {
        Context ret = new Context();
        for (int x = 0; x < inv.size(); ++x) {
            ItemStack stack = inv.getItem(x);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ItemDrawers) {
                if (!ret.drawer.isEmpty()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.getItem() instanceof ItemUpgrade) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.isEmpty() || ret.upgrades.isEmpty()) {
            return null;
        }
        ret.data = new UpgradeData(this, 7){

            @Override
            public boolean setUpgrade(int slot, @NotNull ItemStack upgrade) {
                if (upgrade.isEmpty()) {
                    return false;
                }
                upgrade = upgrade.copy();
                upgrade.setCount(1);
                this.upgrades[slot] = upgrade;
                return true;
            }
        };
        CustomData blocKEntityData = (CustomData)ret.drawer.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blocKEntityData != null) {
            ret.data.read(registries, blocKEntityData.copyTag());
        } else {
            CustomData customData = (CustomData)ret.drawer.get(DataComponents.CUSTOM_DATA);
            if (customData != null) {
                ret.data.read(registries, customData.copyTag());
            }
        }
        for (ItemStack upgrade : ret.upgrades) {
            if (upgrade.getItem() == ModItems.ONE_STACK_UPGRADE.get()) {
                return null;
            }
            if (!ret.data.hasEmptySlot() || !ret.data.canAddUpgrade(upgrade)) {
                return null;
            }
            ret.data.addUpgrade(upgrade);
        }
        return ret;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        ItemStack drawer = ItemStack.EMPTY;
        List<ItemStack> upgrades = new ArrayList<ItemStack>();
        UpgradeData data = null;

        private Context() {
        }
    }
}

