/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements IDynamicBakedModel {
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;

    public PlatformDecoratedModel(BakedModel parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType type) {
        if (state == null) {
            return this.parent.getQuads(state, side, rand, extraData, type);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(state, side, rand, extraData, type);
        if (this.decorator.shouldRenderBase(supplier)) {
            quads.addAll(this.parent.getQuads(state, side, rand, extraData, type));
        }
        BiConsumer<BakedModel, RenderType> emitModel = (model, renderType) -> {
            if (model != null && renderType == type) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
        };
        try {
            this.decorator.emitQuads(supplier, emitModel);
        }
        catch (Exception e) {
            return quads;
        }
        return quads;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.parent.getParticleIcon(data);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of(this.decorator.getRenderTypes(state));
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return this.decorator.getRenderTypes(itemStack);
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        if (this.decorator.shouldRenderItem()) {
            return List.of(new ItemRender(itemStack));
        }
        return this.parent.getRenderPasses(itemStack, fabulous);
    }

    public class ItemRender
    extends ParentModel {
        private ItemStack stack;

        public ItemRender(ItemStack stack) {
            super(PlatformDecoratedModel.this.parent);
            this.stack = stack;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ModelDecorator<ModelContext> decorator = PlatformDecoratedModel.this.decorator;
            Supplier<ModelContext> supplier = () -> PlatformDecoratedModel.this.contextSupplier.makeContext(this.stack);
            if (decorator.shouldRenderBase(supplier, this.stack)) {
                quads.addAll(PlatformDecoratedModel.this.parent.getQuads(state, side, rand));
            }
            BiConsumer<BakedModel, RenderType> emitModel = (model, renderType) -> {
                if (model != null) {
                    quads.addAll(model.getQuads(state, side, rand));
                }
            };
            try {
                decorator.emitItemQuads(supplier, emitModel, this.stack);
            }
            catch (Exception e) {
                return quads;
            }
            return quads;
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return PlatformDecoratedModel.this.parent.getRenderPasses(itemStack, fabulous);
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            return PlatformDecoratedModel.this.parent.getParticleIcon(data);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return PlatformDecoratedModel.this.getRenderTypes(state, rand, data);
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            return PlatformDecoratedModel.this.getRenderTypes(itemStack, fabulous);
        }
    }
}

