/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.storage;

import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IDrawer {
    @NotNull
    public ItemStack getStoredItemPrototype();

    @NotNull
    public IDrawer setStoredItem(@NotNull ItemStack var1);

    @NotNull
    default public IDrawer setStoredItem(@NotNull ItemStack itemPrototype, int amount) {
        IDrawer drawer = this.setStoredItem(itemPrototype);
        drawer.setStoredItemCount(amount);
        return drawer;
    }

    public int getStoredItemCount();

    public void setStoredItemCount(int var1);

    default public int adjustStoredItemCount(int amount) {
        if (amount > 0) {
            int insert = Math.min(amount, this.getRemainingCapacity());
            this.setStoredItemCount(this.getStoredItemCount() + insert);
            return amount - insert;
        }
        if (amount < 0) {
            int stored = this.getStoredItemCount();
            int destroy = Math.min(Math.abs(amount), this.getStoredItemCount());
            this.setStoredItemCount(stored - destroy);
            return Math.abs(amount + destroy);
        }
        return 0;
    }

    default public int getMaxCapacity() {
        return this.getMaxCapacity(this.getStoredItemPrototype());
    }

    public int getMaxCapacity(@NotNull ItemStack var1);

    default public int getAcceptingMaxCapacity(@NotNull ItemStack itemPrototype) {
        return this.getMaxCapacity(itemPrototype);
    }

    public int getRemainingCapacity();

    default public int getAcceptingRemainingCapacity() {
        return this.getRemainingCapacity();
    }

    default public int getStoredItemStackSize() {
        @NotNull ItemStack protoStack = this.getStoredItemPrototype();
        if (protoStack.isEmpty()) {
            return 0;
        }
        return protoStack.getItem().getDefaultMaxStackSize();
    }

    public boolean canItemBeStored(@NotNull ItemStack var1, Predicate<ItemStack> var2);

    default public boolean canItemBeStored(@NotNull ItemStack itemPrototype) {
        return this.canItemBeStored(itemPrototype, null);
    }

    public boolean canItemBeExtracted(@NotNull ItemStack var1, Predicate<ItemStack> var2);

    default public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype) {
        return this.canItemBeExtracted(itemPrototype, null);
    }

    public boolean isEmpty();

    default public boolean isEnabled() {
        return !this.isMissing();
    }

    default public boolean isMissing() {
        return false;
    }

    default public boolean canDetach() {
        return false;
    }

    default public void setDetached(boolean state) {
    }

    public IDrawer copy();
}

