/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.world.block.variant;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.stoneworks.Stoneworks;
import fuzs.stoneworks.config.CommonConfig;
import fuzs.stoneworks.world.block.variant.BlockVariant;
import fuzs.stoneworks.world.block.variant.StoneBlockVariant;
import fuzs.stoneworks.world.block.variant.StoneType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class StoneVariantsProvider {
    private static final Map<String, StoneBlockVariant> STONE_BLOCK_VARIANTS = Maps.newLinkedHashMap();
    @Nullable
    private static Collection<ItemStack> sortedVariantItems;

    public static void invalidateItems() {
        sortedVariantItems = null;
    }

    public static Stream<StoneBlockVariant> getAllStoneBlockVariants() {
        return STONE_BLOCK_VARIANTS.values().stream();
    }

    public static Stream<StoneBlockVariant> getStoneBlockVariants() {
        return STONE_BLOCK_VARIANTS.values().stream().filter(Predicate.not(StoneBlockVariant::isVanillaVariant));
    }

    public static ItemStack[] getDisplayItemStacks() {
        return (ItemStack[])StoneVariantsProvider.getAllStoneBlockVariants().filter(variant -> variant.blockVariant() == BlockVariant.REGULAR).map(StoneBlockVariant::block).map(ItemStack::new).toArray(ItemStack[]::new);
    }

    public static Collection<ItemStack> getSortedVariantItems() {
        if (sortedVariantItems == null) {
            Stream<StoneBlockVariant> stream = Stoneworks.CONFIG.getHolder(CommonConfig.class).isAvailable() && ((CommonConfig)Stoneworks.CONFIG.get(CommonConfig.class)).vanillaVariantsInCreativeTab ? StoneVariantsProvider.getAllStoneBlockVariants() : StoneVariantsProvider.getStoneBlockVariants();
            sortedVariantItems = stream.sorted(Comparator.comparingInt(v -> v.stoneType().ordinal()).thenComparingInt(v -> v.blockVariant().ordinal())).flatMap(StoneBlockVariant::allBlocks).map(Block::asItem).map(ItemStack::new).toList();
        }
        return sortedVariantItems;
    }

    private static void registerAllStoneBlockVariants() {
        for (StoneType stoneType : StoneType.values()) {
            for (BlockVariant blockVariant : BlockVariant.values()) {
                StoneVariantsProvider.registerStoneBlockVariant(new StoneBlockVariant(stoneType, blockVariant), false);
            }
        }
    }

    private static void registerStoneBlockVariant(StoneBlockVariant variant, boolean replace) {
        if (STONE_BLOCK_VARIANTS.put(variant.name(), variant) == null && replace) {
            throw new IllegalStateException("Duplicate stone block variant: " + variant.name());
        }
    }

    public static StoneBlockVariant getStoneVariant(StoneType stoneType, BlockVariant blockVariant) {
        return STONE_BLOCK_VARIANTS.get(blockVariant.getName(stoneType));
    }

    private static void registerVanillaOverrides() {
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.REGULAR, Blocks.STONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.COBBLED, Blocks.COBBLESTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.MOSSY_COBBLED, Blocks.MOSSY_COBBLESTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.BRICKS, Blocks.STONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.MOSSY_BRICKS, Blocks.MOSSY_STONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.CRACKED_BRICKS, Blocks.CRACKED_STONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.POLISHED, Blocks.SMOOTH_STONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.CHISELED, Blocks.CHISELED_STONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.ANDESITE, BlockVariant.REGULAR, Blocks.ANDESITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.ANDESITE, BlockVariant.POLISHED, Blocks.POLISHED_ANDESITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.GRANITE, BlockVariant.REGULAR, Blocks.GRANITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.GRANITE, BlockVariant.POLISHED, Blocks.POLISHED_GRANITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DIORITE, BlockVariant.REGULAR, Blocks.DIORITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DIORITE, BlockVariant.POLISHED, Blocks.POLISHED_DIORITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.REGULAR, Blocks.DEEPSLATE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.COBBLED, Blocks.COBBLED_DEEPSLATE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.BRICKS, Blocks.DEEPSLATE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CRACKED_BRICKS, Blocks.CRACKED_DEEPSLATE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.POLISHED, Blocks.POLISHED_DEEPSLATE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CHISELED, Blocks.CHISELED_DEEPSLATE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.TILES, Blocks.DEEPSLATE_TILES);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CRACKED_TILES, Blocks.CRACKED_DEEPSLATE_TILES);
        StoneVariantsProvider.registerVanillaOverride(StoneType.CALCITE, BlockVariant.REGULAR, Blocks.CALCITE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.TUFF, BlockVariant.REGULAR, Blocks.TUFF);
        StoneVariantsProvider.registerVanillaOverride(StoneType.TUFF, BlockVariant.BRICKS, Blocks.TUFF_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.TUFF, BlockVariant.POLISHED, Blocks.POLISHED_TUFF);
        StoneVariantsProvider.registerVanillaOverride(StoneType.TUFF, BlockVariant.CHISELED, Blocks.CHISELED_TUFF);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.REGULAR, Blocks.BASALT);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.POLISHED, Blocks.SMOOTH_BASALT);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.PILLAR, Blocks.POLISHED_BASALT);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.REGULAR, Blocks.BLACKSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.BRICKS, Blocks.POLISHED_BLACKSTONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.CRACKED_BRICKS, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.POLISHED, Blocks.POLISHED_BLACKSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.CHISELED, Blocks.CHISELED_POLISHED_BLACKSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.REGULAR, Blocks.NETHERRACK);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.CHISELED, Blocks.CHISELED_NETHER_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.TILES, Blocks.NETHER_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.CRACKED_TILES, Blocks.CRACKED_NETHER_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.END_STONE, BlockVariant.REGULAR, Blocks.END_STONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.END_STONE, BlockVariant.BRICKS, Blocks.END_STONE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PURPUR, BlockVariant.PLATES, Blocks.PURPUR_BLOCK, Blocks.PURPUR_STAIRS, Blocks.PURPUR_SLAB);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PURPUR, BlockVariant.PILLAR, Blocks.PURPUR_PILLAR);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PRISMARINE, BlockVariant.REGULAR, Blocks.PRISMARINE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PRISMARINE, BlockVariant.SHINGLES, Blocks.PRISMARINE_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DARK_PRISMARINE, BlockVariant.PAVERS, Blocks.DARK_PRISMARINE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.REGULAR, Blocks.SANDSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.POLISHED, Blocks.CUT_SANDSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.CHISELED, Blocks.CHISELED_SANDSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.REGULAR, Blocks.RED_SANDSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.POLISHED, Blocks.CUT_RED_SANDSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.CHISELED, Blocks.CHISELED_RED_SANDSTONE);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.REGULAR, Blocks.QUARTZ_BLOCK);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.BRICKS, Blocks.QUARTZ_BRICKS);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.CHISELED, Blocks.CHISELED_QUARTZ_BLOCK);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.PILLAR, Blocks.QUARTZ_PILLAR);
    }

    private static void registerVanillaOverride(StoneType stoneType, BlockVariant blockVariant, Block ... blocks) {
        StoneVariantsProvider.registerStoneBlockVariant(new VanillaStoneBlockVariant(stoneType, blockVariant, blocks), true);
    }

    static {
        StoneVariantsProvider.registerAllStoneBlockVariants();
        StoneVariantsProvider.registerVanillaOverrides();
    }

    private static class VanillaStoneBlockVariant
    extends StoneBlockVariant {
        private final String block;
        private final boolean deviates;

        VanillaStoneBlockVariant(StoneType stoneType, BlockVariant blockVariant, Block ... blocks) {
            super(stoneType, blockVariant, Arrays.copyOf(blocks, 4));
            if (blocks.length < 1 || blocks.length > 4) {
                throw new IllegalStateException("Wrong number of blocks provided!");
            }
            this.block = BuiltInRegistries.BLOCK.getKey((Object)blocks[0]).getPath();
            this.deviates = !this.blockName().equals(this.name());
        }

        @Override
        public String blockName() {
            return this.block;
        }

        @Override
        public String stairsName() {
            return this.deviates ? this.blockName() + "_stairs" : super.stairsName();
        }

        @Override
        public String slabName() {
            return this.deviates ? this.blockName() + "_slab" : super.slabName();
        }

        @Override
        public String wallName() {
            return this.deviates ? this.blockName() + "_wall" : super.wallName();
        }

        @Override
        public ResourceLocation id(String key) {
            return ResourceLocationHelper.withDefaultNamespace((String)key);
        }

        @Override
        public boolean isVanillaVariant() {
            return true;
        }
    }
}

