/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.apache.commons.lang3.mutable.MutableFloat;

public final class BlockEnchantmentHelper {
    private static final EnchantedItemInUse EMPTY_ENCHANTED_ITEM = new EnchantedItemInUse(ItemStack.EMPTY, null, null, Function.identity()::apply);

    private BlockEnchantmentHelper() {
    }

    public static double getAttributeValue(Holder<Attribute> holder, ItemEnchantments itemEnchantments) {
        AttributeInstance attributeInstance = new AttributeInstance(holder, Function.identity()::apply);
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchantmentEffectComponents.ATTRIBUTES).forEach(enchantmentAttributeEffect -> attributeInstance.addTransientModifier(enchantmentAttributeEffect.getModifier(entry.getIntValue(), (StringRepresentable)EquipmentSlot.MAINHAND)));
        }
        return attributeInstance.getValue();
    }

    public static float modifyDamage(ServerLevel level, Entity entity, DamageSource damageSource, float damage, ItemEnchantments itemEnchantments) {
        MutableFloat mutableFloat = new MutableFloat(damage);
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            ((Enchantment)((Holder)entry.getKey()).value()).modifyDamage(level, entry.getIntValue(), ItemStack.EMPTY, entity, damageSource, mutableFloat);
        }
        return mutableFloat.floatValue();
    }

    public static void doPostAttackEffects(ServerLevel level, Entity entity, DamageSource damageSource, ItemEnchantments itemEnchantments) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                ((Enchantment)((Holder)entry.getKey()).value()).doPostAttack(level, entry.getIntValue(), EMPTY_ENCHANTED_ITEM, EnchantmentTarget.ATTACKER, (Entity)livingEntity, damageSource);
            }
        }
    }

    public static float modifyKnockback(ServerLevel level, Entity entity, DamageSource damageSource, float knockback, ItemEnchantments itemEnchantments) {
        MutableFloat mutableFloat = new MutableFloat(knockback);
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            ((Enchantment)((Holder)entry.getKey()).value()).modifyKnockback(level, entry.getIntValue(), ItemStack.EMPTY, entity, damageSource, mutableFloat);
        }
        return mutableFloat.floatValue();
    }
}

