/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.item;

import fuzs.spikyspikes.world.level.block.SpikeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class SpikeItem
extends BlockItem {
    public SpikeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockState = this.getBlock().getStateForPlacement(context);
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        return blockState != null && level.isUnobstructed(blockState, blockPos, CollisionContext.empty()) ? blockState : null;
    }

    public boolean isEnchantable(ItemStack stack) {
        if (this.acceptsEnchantments()) {
            return stack.getCount() == 1;
        }
        return super.isEnchantable(stack);
    }

    public int getEnchantmentValue() {
        if (this.acceptsEnchantments()) {
            return 1;
        }
        return super.getEnchantmentValue();
    }

    public boolean isFoil(ItemStack stack) {
        if (this.acceptsEnchantments()) {
            return !((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty();
        }
        return super.isFoil(stack);
    }

    public boolean acceptsEnchantments() {
        return ((SpikeBlock)this.getBlock()).getSpikeMaterial().dropsPlayerLoot();
    }
}

