/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.spikyspikes.client.model.geom.ModelPartCopy;
import fuzs.spikyspikes.client.model.geom.ShapeModelPart;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.SpikeBlockEntity;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;

public class SpikeRenderer
implements BlockEntityRenderer<SpikeBlockEntity> {
    private static final Map<SpikeMaterial, Material> MATERIAL_BY_TYPE;
    private static final ModelPartCopy MODEL;
    private static final ModelPartCopy INVENTORY_MODEL;

    public SpikeRenderer(BlockEntityRendererProvider.Context context) {
    }

    private static void registerMaterial(SpikeMaterial spikeMaterial, ResourceLocation resourceLocation, BiConsumer<SpikeMaterial, Material> registrar) {
        registrar.accept(spikeMaterial, new Material(InventoryMenu.BLOCK_ATLAS, resourceLocation));
    }

    public void render(SpikeBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)SpikeBlock.FACING);
        SpikeMaterial spikeMaterial = ((SpikeBlock)blockEntity.getBlockState().getBlock()).getSpikeMaterial();
        SpikeRenderer.renderSpike(direction, spikeMaterial, poseStack, multiBufferSource, packedLight, packedOverlay, false, blockEntity.hasFoil());
    }

    public static void renderSpike(Direction direction, SpikeMaterial spikeMaterial, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean inventoryRendering, boolean withFoil) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.scale(0.9995f, 0.9995f, 0.9995f);
        poseStack.mulPose(direction.getOpposite().getRotation());
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material material = MATERIAL_BY_TYPE.get((Object)spikeMaterial);
        VertexConsumer vertexConsumer = material.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)material.renderType(RenderType::entitySolid), (boolean)true, (boolean)withFoil));
        ModelPartCopy model = inventoryRendering ? INVENTORY_MODEL : MODEL;
        model.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SpikeRenderer.registerMaterial(SpikeMaterial.WOOD, ResourceLocationHelper.withDefaultNamespace((String)"block/stripped_oak_log"), (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        SpikeRenderer.registerMaterial(SpikeMaterial.STONE, ResourceLocationHelper.withDefaultNamespace((String)"block/smooth_stone"), (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        SpikeRenderer.registerMaterial(SpikeMaterial.IRON, ResourceLocationHelper.withDefaultNamespace((String)"block/iron_block"), (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        SpikeRenderer.registerMaterial(SpikeMaterial.GOLD, ResourceLocationHelper.withDefaultNamespace((String)"block/gold_block"), (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        SpikeRenderer.registerMaterial(SpikeMaterial.DIAMOND, ResourceLocationHelper.withDefaultNamespace((String)"block/diamond_block"), (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        SpikeRenderer.registerMaterial(SpikeMaterial.NETHERITE, ResourceLocationHelper.withDefaultNamespace((String)"block/netherite_block"), (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        MATERIAL_BY_TYPE = builder.build();
        MODEL = ShapeModelPart.pyramid(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, false);
        INVENTORY_MODEL = ShapeModelPart.pyramid(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, true);
    }
}

