/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.client.model.geom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Quaternionf;

public final class ModelPartCopy {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private final List<ModelPart.Cube> cubes;
    private final Map<String, ModelPartCopy> children;

    public ModelPartCopy(List<ModelPart.Cube> cubes, Map<String, ModelPartCopy> children) {
        this.cubes = cubes;
        this.children = children;
    }

    public void render(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.render(poseStack, buffer, packedLight, packedOverlay, -1);
    }

    public void render(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            poseStack.pushPose();
            this.translateAndRotate(poseStack);
            this.compile(poseStack.last(), buffer, packedLight, packedOverlay, color);
            for (ModelPartCopy modelPart : this.children.values()) {
                modelPart.render(poseStack, buffer, packedLight, packedOverlay, color);
            }
            poseStack.popPose();
        }
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.translate(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.mulPose(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        for (ModelPart.Cube cube : this.cubes) {
            cube.compile(pose, buffer, packedLight, packedOverlay, color);
        }
    }
}

