/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sneakycurses.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.sneakycurses.SneakyCurses;
import fuzs.sneakycurses.config.ServerConfig;
import fuzs.sneakycurses.init.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class CurseRevealHandler {
    public static final String KEY_ITEM_CURSES_REVEALED = "item.sneakycurses.curses_revealed";
    public static final String TAG_CURSES_REVEALED = SneakyCurses.id("curses_revealed").toString();

    public static EventResult onAnvilUpdate(ItemStack leftInput, ItemStack rightInput, MutableValue<ItemStack> output, String itemName, MutableInt enchantmentCost, MutableInt materialCost, Player player) {
        if (CurseRevealHandler.isAffected(leftInput) && rightInput.is(ModRegistry.REVEALS_CURSES_ITEM_TAG) && !CurseRevealHandler.allCursesRevealed(leftInput)) {
            ItemStack itemStack = leftInput.copy();
            CurseRevealHandler.revealAllCurses(itemStack);
            output.accept((Object)itemStack);
            materialCost.accept(1);
            enchantmentCost.accept(((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).revealCursesCost);
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onEndEntityTick(Entity entity) {
        block3: {
            LivingEntity livingEntity;
            block4: {
                if (entity.level().isClientSide || entity.tickCount % 1200 != 0 || !(entity instanceof LivingEntity)) break block3;
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player)) break block4;
                Player player = (Player)entity;
                if (player.getAbilities().invulnerable) break block3;
            }
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack itemStack = livingEntity.getItemBySlot(equipmentSlot);
                if (livingEntity.getEquipmentSlotForItem(itemStack) != equipmentSlot || !CurseRevealHandler.anyEnchantIsCursed(itemStack) || CurseRevealHandler.allCursesRevealed(itemStack) || !(entity.getRandom().nextDouble() < ((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).curseRevealChance)) continue;
                CurseRevealHandler.revealAllCurses(itemStack);
                entity.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, entity.getRandom().nextFloat() * 0.1f + 0.9f);
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)KEY_ITEM_CURSES_REVEALED, (Object[])new Object[]{itemStack.getDisplayName()}).withStyle(ChatFormatting.DARK_PURPLE), false);
                break;
            }
        }
    }

    public static void revealAllCurses(ItemStack itemStack) {
        if (CurseRevealHandler.anyEnchantIsCursed(itemStack)) {
            itemStack.set((DataComponentType)ModRegistry.REVEAL_CURSES_DATA_COMPONENT_TYPE.value(), (Object)Unit.INSTANCE);
        }
    }

    public static boolean allCursesRevealed(ItemStack itemStack) {
        return itemStack.has((DataComponentType)ModRegistry.REVEAL_CURSES_DATA_COMPONENT_TYPE.value());
    }

    public static boolean anyEnchantIsCursed(ItemStack itemStack) {
        return !itemStack.isEmpty() && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack).keySet().stream().anyMatch(holder -> holder.is(EnchantmentTags.CURSE));
    }

    public static boolean isAffected(ItemStack itemStack) {
        if (itemStack.getItem() instanceof EnchantedBookItem && !((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).affectBooks) {
            return false;
        }
        return CurseRevealHandler.anyEnchantIsCursed(itemStack);
    }
}

