/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sneakycurses.client.handler;

import com.google.common.collect.MapMaker;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.sneakycurses.SneakyCurses;
import fuzs.sneakycurses.client.util.ComponentHelper;
import fuzs.sneakycurses.config.ServerConfig;
import fuzs.sneakycurses.handler.CurseRevealHandler;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipHandler {
    private static final Map<Enchantment, Integer> ENCHANTMENT_IDS = new MapMaker().weakKeys().concurrencyLevel(1).makeMap();
    private static final Random RANDOM = new Random();
    private static int currentScreenSeed;

    public static void onAfterInit(Minecraft minecraft, Screen screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, UnaryOperator<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        ItemTooltipHandler.setFreshSeed();
    }

    private static void setFreshSeed() {
        currentScreenSeed = RANDOM.nextInt();
    }

    public static void onItemTooltip(ItemStack itemStack, List<Component> lines, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isCreative() || tooltipContext.registries() == null) {
            return;
        }
        if (!SneakyCurses.CONFIG.getHolder(ServerConfig.class).isAvailable() || !((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).obfuscateCurses) {
            return;
        }
        if (!ItemTooltipHandler.isAffected(player, itemStack)) {
            return;
        }
        ListIterator<Component> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            TranslatableContents contents;
            ComponentContents componentContents = iterator.next().getContents();
            if (!(componentContents instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).getKey().startsWith("enchantment.")) continue;
            String[] enchantmentKey = contents.getKey().split("\\.");
            Holder enchantment = null;
            if (enchantmentKey.length >= 3) {
                HolderLookup.RegistryLookup enchantments = tooltipContext.registries().lookupOrThrow(Registries.ENCHANTMENT);
                ResourceLocation resourceLocation = ResourceLocationHelper.fromNamespaceAndPath((String)enchantmentKey[1], (String)enchantmentKey[2]);
                enchantment = enchantments.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)resourceLocation)).orElse(null);
            }
            if (enchantment == null || !enchantment.is(EnchantmentTags.CURSE)) continue;
            if (enchantmentKey.length == 3) {
                int enchantmentId = ENCHANTMENT_IDS.computeIfAbsent((Enchantment)enchantment.value(), $ -> RANDOM.nextInt());
                ItemTooltipHandler.initSeed(currentScreenSeed + enchantmentId);
                Component component = ItemTooltipHandler.getLoreForWidth(Minecraft.getInstance().font);
                iterator.set((Component)Component.empty().append(component).withStyle(ChatFormatting.RED));
                continue;
            }
            iterator.remove();
        }
    }

    private static boolean isAffected(@Nullable Player player, ItemStack itemStack) {
        if (player != null && player.level().isClientSide) {
            if (itemStack.isEmpty()) {
                return false;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.gameMode.hasInfiniteItems() && Screen.hasShiftDown() && ((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).shiftShows) {
                return false;
            }
            if (itemStack.getItem() instanceof EnchantedBookItem && !((ServerConfig)SneakyCurses.CONFIG.get(ServerConfig.class)).affectBooks) {
                return false;
            }
            Screen screen = minecraft.screen;
            if (screen instanceof AnvilScreen) {
                Slot inputSlot;
                AnvilScreen screen2 = (AnvilScreen)screen;
                Slot hoveredSlot = screen2.hoveredSlot;
                if (hoveredSlot != null && ((AnvilMenu)screen2.getMenu()).getResultSlot() == hoveredSlot.index && hoveredSlot.getItem() == itemStack && !CurseRevealHandler.allCursesRevealed((inputSlot = ((AnvilMenu)screen2.getMenu()).getSlot(0)).getItem())) {
                    return true;
                }
            }
            return CurseRevealHandler.isAffected(itemStack) && !CurseRevealHandler.allCursesRevealed(itemStack);
        }
        return false;
    }

    private static void initSeed(long seed) {
        RANDOM.setSeed(seed);
        EnchantmentNames.getInstance().initSeed(seed);
    }

    private static Component getLoreForWidth(Font font) {
        double maxWidth = RANDOM.nextGaussian(100.0, 20.0);
        FormattedText formattedText = EnchantmentNames.getInstance().getRandomName(font, (int)maxWidth);
        return ComponentHelper.toComponent(formattedText);
    }
}

