/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.shaded.japng.reader;

import cz.lukaskabc.minecraft.mod_loader.shaded.japng.PngAnimationType;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.PngChunkCode;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngAnimationControl;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngFrameControl;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngGamma;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngHeader;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngIntegrityException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.map.PngChunkMap;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.reader.PngChunkProcessor;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.reader.PngChunkReader;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.reader.PngSource;
import java.io.IOException;

public class DefaultPngChunkReader<ResultT>
implements PngChunkReader<ResultT> {
    protected PngChunkProcessor<ResultT> processor;
    protected boolean seenHeader = false;
    protected int idatCount = 0;
    protected int apngSequenceExpect = 0;
    protected PngAnimationType animationType = PngAnimationType.NOT_ANIMATED;

    public DefaultPngChunkReader(PngChunkProcessor<ResultT> processor) {
        this.processor = processor;
    }

    @Override
    public boolean readChunk(PngSource source, int code, int dataLength) throws PngException, IOException {
        int dataPosition = source.tell();
        if (dataLength < 0) {
            throw new PngIntegrityException(String.format("Corrupted read (Data length %d)", dataLength));
        }
        switch (code) {
            case 1229472850: {
                this.readHeaderChunk(source, dataLength);
                break;
            }
            case 1229278788: {
                break;
            }
            case 1732332865: {
                this.readGammaChunk(source, dataLength);
                break;
            }
            case 1649100612: {
                this.readBackgroundChunk(source, dataLength);
                break;
            }
            case 1951551059: {
                this.readTransparencyChunk(source, dataLength);
                break;
            }
            case 1347179589: {
                this.readPaletteChunk(source, dataLength);
                break;
            }
            case 1229209940: {
                this.readImageDataChunk(source, dataLength);
                break;
            }
            case 1633899596: {
                this.readAnimationControlChunk(source, dataLength);
                break;
            }
            case 1717785676: {
                this.readFrameControlChunk(source, dataLength);
                break;
            }
            case 1717846356: {
                this.readFrameImageDataChunk(source, dataLength);
                break;
            }
            default: {
                this.readOtherChunk(code, source, dataPosition, dataLength);
            }
        }
        int chunkChecksum = source.readInt();
        this.processChunkEnd(code, dataPosition, dataLength, chunkChecksum);
        return code == 1229278788;
    }

    @Override
    public void processChunkEnd(int code, int dataPosition, int dataLength, int chunkChecksum) throws PngException {
        this.processor.processChunkMapItem(new PngChunkMap(PngChunkCode.from(code), dataPosition, dataLength, chunkChecksum));
    }

    @Override
    public void readHeaderChunk(PngSource source, int dataLength) throws IOException, PngException {
        PngHeader header = PngHeader.from(source.getDis());
        this.seenHeader = true;
        this.processor.processHeader(header);
    }

    @Override
    public void readGammaChunk(PngSource source, int dataLength) throws PngException, IOException {
        this.processor.processGamma(PngGamma.from(source.getDis()));
    }

    @Override
    public void readTransparencyChunk(PngSource source, int dataLength) throws IOException, PngException {
        if (source.supportsByteAccess()) {
            this.processor.processTransparency(source.getBytes(), source.tell(), dataLength);
            source.skip(dataLength);
        } else {
            byte[] paletteBytes = new byte[dataLength];
            source.getDis().readFully(paletteBytes);
            this.processor.processTransparency(paletteBytes, 0, dataLength);
        }
    }

    @Override
    public void readBackgroundChunk(PngSource source, int dataLength) throws IOException, PngException {
        if (!this.seenHeader) {
            throw new PngIntegrityException("bKGD chunk received before IHDR chunk");
        }
        source.skip(dataLength);
    }

    @Override
    public void readPaletteChunk(PngSource source, int dataLength) throws IOException, PngException {
        if (dataLength % 3 != 0) {
            throw new PngIntegrityException(String.format("png spec: palette chunk length must be divisible by 3: %d", dataLength));
        }
        if (source.supportsByteAccess()) {
            this.processor.processPalette(source.getBytes(), source.tell(), dataLength);
            source.skip(dataLength);
        } else {
            byte[] paletteBytes = new byte[dataLength];
            source.getDis().readFully(paletteBytes);
            this.processor.processPalette(paletteBytes, 0, dataLength);
        }
    }

    @Override
    public void readImageDataChunk(PngSource source, int dataLength) throws PngException, IOException {
        if (this.idatCount == 0 && this.apngSequenceExpect == 0) {
            this.animationType = PngAnimationType.NOT_ANIMATED;
        }
        ++this.idatCount;
        switch (this.animationType) {
            case ANIMATED_DISCARD_DEFAULT_IMAGE: {
                source.skip(dataLength);
                break;
            }
            case ANIMATED_KEEP_DEFAULT_IMAGE: {
                this.processor.processFrameImageData(source.slice(dataLength), PngChunkCode.IDAT, source.tell(), dataLength);
                break;
            }
            default: {
                this.processor.processDefaultImageData(source.slice(dataLength), PngChunkCode.IDAT, source.tell(), dataLength);
            }
        }
    }

    @Override
    public void readAnimationControlChunk(PngSource source, int dataLength) throws IOException, PngException {
        if (dataLength != 8) {
            throw new PngIntegrityException(String.format("acTL chunk length must be %d, not %d", 8, dataLength));
        }
        this.processor.processAnimationControl(new PngAnimationControl(source.readInt(), source.readInt()));
    }

    @Override
    public void readFrameControlChunk(PngSource source, int dataLength) throws IOException, PngException {
        if (dataLength != 26) {
            throw new PngIntegrityException(String.format("fcTL chunk length must be %d, not %d", 26, dataLength));
        }
        int sequence = source.readInt();
        if (sequence != this.apngSequenceExpect) {
            throw new PngIntegrityException(String.format("fctl chunk expected sequence %d but received %d", this.apngSequenceExpect, sequence));
        }
        ++this.apngSequenceExpect;
        PngFrameControl frame = new PngFrameControl(sequence, source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readUnsignedShort(), source.readUnsignedShort(), source.readByte(), source.readByte());
        if (sequence == 0) {
            this.animationType = this.idatCount == 0 ? PngAnimationType.ANIMATED_KEEP_DEFAULT_IMAGE : PngAnimationType.ANIMATED_DISCARD_DEFAULT_IMAGE;
        }
        this.processor.processFrameControl(frame);
    }

    @Override
    public void readFrameImageDataChunk(PngSource source, int dataLength) throws IOException, PngException {
        int position = source.tell();
        int sequence = source.readInt();
        dataLength -= 4;
        if (sequence != this.apngSequenceExpect) {
            throw new PngIntegrityException(String.format("fdAT chunk expected sequence %d but received %d", this.apngSequenceExpect, sequence));
        }
        ++this.apngSequenceExpect;
        this.processor.processFrameImageData(source.slice(dataLength), PngChunkCode.fdAT, source.tell(), dataLength);
    }

    @Override
    public void readOtherChunk(int code, PngSource source, int dataPosition, int dataLength) throws IOException {
        source.skip(dataLength);
    }

    @Override
    public void finishedChunks(PngSource source) throws PngException, IOException {
    }

    @Override
    public ResultT getResult() {
        return this.processor.getResult();
    }

    public boolean isSeenHeader() {
        return this.seenHeader;
    }

    public int getIdatCount() {
        return this.idatCount;
    }

    public int getApngSequenceExpect() {
        return this.apngSequenceExpect;
    }

    public PngAnimationType getAnimationType() {
        return this.animationType;
    }
}

