/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;

public class StaticSTBHelper {
    private StaticSTBHelper() {
        throw new AssertionError();
    }

    public static ByteBuffer readToBuffer(InputStream inputStream, int initialCapacity) {
        ByteBuffer buf;
        try (ReadableByteChannel channel = Channels.newChannel(inputStream);){
            int readbytes;
            buf = BufferUtils.createByteBuffer((int)(initialCapacity + 1));
            while ((readbytes = channel.read(buf)) != -1) {
                if (buf.remaining() != 0) continue;
                ByteBuffer newBuf = BufferUtils.createByteBuffer((int)(buf.capacity() * 3 / 2));
                buf.flip();
                newBuf.put(buf);
                buf = newBuf;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        buf.flip();
        return MemoryUtil.memSlice((ByteBuffer)buf);
    }

    public static int resolveAndBindTexture(String file, int[] textureWidth, int[] textureHeight) throws FileNotFoundException {
        int[] lc = new int[1];
        int[] fileSize = new int[]{300000};
        InputStream inputStream = ConfigLoader.resolveFile(Path.of(file, new String[0]), fileSize);
        ByteBuffer buf = StaticSTBHelper.readToBuffer(inputStream, fileSize[0]);
        ByteBuffer img = STBImage.stbi_load_from_memory((ByteBuffer)buf, (int[])textureWidth, (int[])textureHeight, (int[])lc, (int)4);
        int texid = GL32C.glGenTextures();
        StaticSTBHelper.bindTexture(img, texid, textureWidth, textureHeight);
        return texid;
    }

    public static void bindTexture(@Nullable ByteBuffer textureData, int textureId, int[] width, int[] height) {
        GL32C.glActiveTexture((int)33984);
        GL32C.glBindTexture((int)3553, (int)textureId);
        GL32C.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL32C.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32C.glTexImage2D((int)3553, (int)0, (int)6408, (int)width[0], (int)height[0], (int)0, (int)6408, (int)5121, (ByteBuffer)textureData);
        GL32C.glActiveTexture((int)33984);
        GL32C.glBindTexture((int)3553, (int)0);
        MemoryUtil.memFree((Buffer)textureData);
    }
}

