/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigLoader;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigurationException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper.ApngTexture;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.Png;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888BitmapSequence;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL32C;

public class ApngSTBHelper {
    public static final int MAX_TEXTURE_SIZE = GL32C.glGetInteger((int)3379);
    private static final Logger LOG = LogManager.getLogger();

    private ApngSTBHelper() {
        throw new AssertionError();
    }

    public static ApngTexture resolveAndBindApngTexture(String file) throws FileNotFoundException, PngException {
        InputStream inputStream = ConfigLoader.resolveFile(Path.of(file, new String[0]), null);
        Argb8888BitmapSequence argbSequence = Png.readArgb8888BitmapSequence(inputStream);
        if (!argbSequence.isAnimated()) {
            throw new ConfigurationException("APNG file is not animated: " + file);
        }
        ApngTexture apngTexture = new ApngTexture(argbSequence);
        if (apngTexture.getTotalHeight() >= MAX_TEXTURE_SIZE || apngTexture.getTotalWidth() >= MAX_TEXTURE_SIZE) {
            LOG.error("APNG file {} reaches the maximum hardware texture size of {}x{}", (Object)file, (Object)MAX_TEXTURE_SIZE, (Object)MAX_TEXTURE_SIZE);
            throw new ConfigurationException("APNG file is too big: " + file);
        }
        apngTexture.uploadTextures(argbSequence.getAnimationFrames());
        return apngTexture;
    }

    public static ByteBuffer reallocateWhenRequired(@Nullable ByteBuffer buffer, int requiredSize) {
        if (buffer == null || buffer.capacity() < requiredSize) {
            buffer = BufferUtils.createByteBuffer((int)requiredSize);
        }
        buffer.clear();
        return buffer;
    }

    public static int argbToRgba(int argb) {
        return (argb & 0xFF0000) >> 16 | argb & 0xFF00 | (argb & 0xFF) << 16 | argb & 0xFF000000;
    }
}

