/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups.config;

import de.melanx.simplebackups.StorageSize;
import de.melanx.simplebackups.config.BackupType;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfig {
    public static final ModConfigSpec CONFIG;
    private static final ModConfigSpec.Builder BUILDER;
    private static final String DEFAULT_DISK_SIZE = "25 GB";
    private static ModConfigSpec.BooleanValue enabled;
    private static ModConfigSpec.EnumValue<BackupType> backupType;
    private static ModConfigSpec.IntValue fullBackupTimer;
    private static ModConfigSpec.IntValue backupsToKeep;
    private static ModConfigSpec.IntValue timer;
    private static ModConfigSpec.IntValue compressionLevel;
    private static ModConfigSpec.BooleanValue sendMessages;
    private static ModConfigSpec.ConfigValue<String> maxDiskSize;
    private static ModConfigSpec.ConfigValue<String> outputPath;
    private static ModConfigSpec.BooleanValue noPlayerBackups;
    private static ModConfigSpec.BooleanValue createSubDirs;
    private static ModConfigSpec.BooleanValue useTickCounter;
    private static ModConfigSpec.ConfigValue<List<? extends String>> ignoredPaths;
    private static ModConfigSpec.ConfigValue<List<? extends String>> ignoredFiles;
    private static ModConfigSpec.ConfigValue<String> ignoredFilesRegex;
    private static ModConfigSpec.BooleanValue mc2discord;

    public static void init(ModConfigSpec.Builder builder) {
        enabled = builder.comment("If set false, no backups are being made.").define("enabled", true);
        backupType = builder.comment("Defines the backup type.\n- FULL_BACKUPS - always creates full backups\n- MODIFIED_SINCE_LAST - only saves the files which changed since last (partial) backup\n- MODIFIED_SINCE_FULL - saves all files which changed after the last full backup").defineEnum("backupType", (Enum)BackupType.FULL_BACKUPS);
        fullBackupTimer = builder.comment("How often should a full backup be created if only modified files should be saved? This creates a full backup when x minutes are over and the next backup needs to be done. Once a year is default.").defineInRange("fullBackupTimer", 525960, 1, 5259600);
        backupsToKeep = builder.comment("The max amount of backup files to keep.").defineInRange("backupsToKeep", 10, 1, Short.MAX_VALUE);
        timer = builder.comment(new String[]{"The time between two backups in minutes", "5 = each 5 minutes", "60 = each hour", "1440 = each day"}).defineInRange("timer", 120, 1, Short.MAX_VALUE);
        compressionLevel = builder.comment(new String[]{"Compression level:", "  0  = no compression (low CPU usage, larger files)", "  9  = maximum compression (high CPU usage, smaller files)", "  -1 = default; balances speed and compression (recommended)"}).defineInRange("compressionLevel", -1, Math.min(-1, 0), 9);
        sendMessages = builder.comment("Should message be sent when backup is in the making?").define("sendMessages", true);
        maxDiskSize = builder.comment(new String[]{"The max size of storage the backup folder. If it takes more storage, old files will be deleted.", "Needs to be written as <number><space><storage type>", "Valid storage types: B, KB, MB, GB, TB"}).define("maxDiskSize", (Object)DEFAULT_DISK_SIZE);
        outputPath = builder.comment("Used to define the output path.").define("outputPath", (Object)"simplebackups");
        noPlayerBackups = builder.comment("Create backups, even if nobody is online").define("noPlayerBackups", false);
        createSubDirs = builder.comment(new String[]{"Should sub-directories be generated for each world?", "Keep in mind that all configs above, including backupsToKeep and maxDiskSize, will be calculated for each sub directory."}).define("createSubDirs", true);
        useTickCounter = builder.comment(new String[]{"Use an internal tick counter instead of the real world time. The value of the timer will be converted to ticks. When the timer is over, the backup will be created.", "Keep in mind that lagging servers will result in larger gaps between two backups, e.g. 10 FPS in average will result in double the time set between backups."}).define("useTickCounter", false);
        builder.comment(new String[]{"WARNING Please check your configuration before using permanently.", "The backup system will ignore these paths and files."}).push("to_ignore");
        ignoredPaths = builder.comment(new String[]{"All directories that should be excluded from backups", "Format: Enter paths relative to the world directory (e.g., 'logs', 'data/cache')", "All files within these directories will also be excluded"}).defineList("ignored_paths", List.of(), () -> "", obj -> obj instanceof String);
        ignoredFiles = builder.comment(new String[]{"Specific files that should be excluded from backups", "Format: Enter complete file paths relative to the world directory (e.g., 'level.dat_old', 'stats/player.json')", "Use this for individual files rather than entire directories"}).defineList("ignored_files", List.of(), () -> "", obj -> obj instanceof String);
        ignoredFilesRegex = builder.comment(new String[]{"Regular expression pattern to exclude matching files from backups", "All files with paths matching this pattern will be skipped", "Example: '.*\\.temp$' excludes all files ending with .temp", "Leave empty to disable regex-based file exclusion"}).define("ignored_files_regex", (Object)"");
        builder.pop();
        builder.push("mod_compat");
        mc2discord = builder.comment("Should backup notifications be sent to Discord by using mc2discord? (needs to be installed)").define("mc2discord", true);
        builder.pop();
    }

    public static boolean isEnabled() {
        return (Boolean)enabled.get();
    }

    public static int getBackupsToKeep() {
        return (Integer)backupsToKeep.get();
    }

    public static int getTimer() {
        return (Integer)timer.get() * 60 * 1000;
    }

    public static int getFullBackupTimer() {
        return (Integer)fullBackupTimer.get() * 60 * 1000;
    }

    public static int getCompressionLevel() {
        return (Integer)compressionLevel.get();
    }

    public static long getMaxDiskSize() {
        String s = (String)maxDiskSize.get();
        if (s.split(" ").length != 2) {
            s = DEFAULT_DISK_SIZE;
        }
        return StorageSize.getBytes(s);
    }

    public static Path getOutputPath(@Nullable String levelId) {
        Path base = Paths.get((String)outputPath.get(), new String[0]);
        boolean withSubDir = levelId != null && !levelId.isEmpty() && (Boolean)createSubDirs.get() != false;
        try {
            return withSubDir ? base.toRealPath(new LinkOption[0]).resolve(levelId) : base.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return withSubDir ? base.resolve(levelId) : base;
        }
    }

    public static boolean doNoPlayerBackups() {
        return (Boolean)noPlayerBackups.get();
    }

    public static BackupType backupType() {
        return (BackupType)((Object)backupType.get());
    }

    public static boolean sendMessages() {
        return (Boolean)sendMessages.get();
    }

    public static List<Path> getIgnoredPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String path : (List)ignoredPaths.get()) {
            paths.add(Path.of(path, new String[0]));
        }
        return paths;
    }

    public static List<Path> getIgnoredFiles() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String path : (List)ignoredFiles.get()) {
            paths.add(Path.of(path, new String[0]));
        }
        return paths;
    }

    public static String getIgnoredFilesRegex() {
        return (String)ignoredFilesRegex.get();
    }

    public static boolean useTickCounter() {
        return (Boolean)useTickCounter.get();
    }

    public static boolean mc2discord() {
        return (Boolean)mc2discord.get();
    }

    static {
        BUILDER = new ModConfigSpec.Builder();
        CommonConfig.init(BUILDER);
        CONFIG = BUILDER.build();
    }
}

