/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.util.Environment;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import sereneseasons.api.SSBlocks;
import sereneseasons.api.SSItems;
import sereneseasons.init.ModClient;
import sereneseasons.item.CalendarItem;

public class ModItems {
    public static void setup(BiConsumer<ResourceLocation, Item> func) {
        ModItems.registerItems(func);
        ModItems.registerBlockItems(func);
        if (Environment.isClient()) {
            ModClient.registerItemProperties();
        }
    }

    public static void registerItems(BiConsumer<ResourceLocation, Item> func) {
        SSItems.SS_ICON = ModItems.register(func, "ss_icon", new Item(new Item.Properties()));
        SSItems.CALENDAR = ModItems.register(func, "calendar", new CalendarItem(new Item.Properties().stacksTo(1)));
    }

    public static void registerBlockItems(BiConsumer<ResourceLocation, Item> func) {
        SSItems.SEASON_SENSOR = ModItems.register(func, "season_sensor", (Item)new BlockItem(SSBlocks.SEASON_SENSOR, new Item.Properties()));
    }

    private static Item register(BiConsumer<ResourceLocation, Item> func, String name, Item item) {
        func.accept(ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)name), item);
        return item;
    }
}

