/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.ComputeItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.FinalizeItemComponentsCallback;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.api.event.v1.entity.ChangeEntitySizeCallback;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.EntityTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.BabyEntitySpawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CheckMobDespawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ComputeEnchantedLootBonusCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingBreathEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingChangeTargetCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingConversionCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEquipmentChangeCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingJumpCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LookingAtEndermanCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ContainerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.GrindstoneEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PickupExperienceCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.UseBoneMealCallback;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.level.GatherPotentialSpawnsCallback;
import fuzs.puzzleslib.api.event.v1.level.PlayLevelSoundEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerChunkEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelTickEvents;
import fuzs.puzzleslib.api.event.v1.server.AddDataPackReloadListenersCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.SyncDataPackContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.event.CopyOnWriteForwardingList;
import fuzs.puzzleslib.impl.event.EventImplHelper;
import fuzs.puzzleslib.impl.event.PotentialSpawnsList;
import fuzs.puzzleslib.impl.event.core.EventInvokerImpl;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.event.v1.core.NeoForgeEventInvokerRegistry;
import fuzs.puzzleslib.neoforge.api.event.v1.entity.living.ComputeEnchantedLootBonusEvent;
import fuzs.puzzleslib.neoforge.impl.client.event.NeoForgeClientEventInvokers;
import fuzs.puzzleslib.neoforge.impl.init.NeoForgePotionBrewingBuilder;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDrownEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.ModifyRegistriesEvent;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeEventInvokerRegistryImpl
implements NeoForgeEventInvokerRegistry {
    private static boolean frozenModBusEvents;

    public static void registerLoadingHandlers() {
        INSTANCE.register(LoadCompleteCallback.class, FMLLoadCompleteEvent.class, (T callback, E evt) -> evt.enqueueWork(callback::onLoadComplete));
        INSTANCE.register(RegistryEntryAddedCallback.class, ModifyRegistriesEvent.class, NeoForgeEventInvokerRegistryImpl::onRegistryEntryAdded);
        INSTANCE.register(FinalizeItemComponentsCallback.class, ModifyDefaultComponentsEvent.class, (T callback, E evt) -> evt.getAllItems().forEach(item -> callback.onFinalizeItemComponents((Item)item, function -> evt.modify((ItemLike)item, builder -> {
            DataComponentPatch.SplitResult splitResult = ((DataComponentPatch)function.apply(item.components())).split();
            splitResult.added().stream().forEach(arg_0 -> ((DataComponentPatch.Builder)builder).set(arg_0));
            splitResult.removed().forEach(arg_0 -> ((DataComponentPatch.Builder)builder).remove(arg_0));
        }))));
        INSTANCE.register(ComputeItemAttributeModifiersCallback.class, ModifyDefaultComponentsEvent.class, (T callback, E evt) -> evt.getAllItems().forEach(item -> {
            ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)item.components().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            CopyOnWriteForwardingList<ItemAttributeModifiers.Entry> entries = new CopyOnWriteForwardingList<ItemAttributeModifiers.Entry>(itemAttributeModifiers.modifiers());
            callback.onComputeItemAttributeModifiers((Item)item, (List<ItemAttributeModifiers.Entry>)entries);
            if (entries.delegate() != itemAttributeModifiers.modifiers()) {
                evt.modify((ItemLike)item, builder -> builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers((List)ImmutableList.copyOf((Collection)entries), itemAttributeModifiers.showInTooltip())));
            }
        }));
        INSTANCE.register(AddBlockEntityTypeBlocksCallback.class, BlockEntityTypeAddBlocksEvent.class, (T callback, E evt) -> callback.onAddBlockEntityTypeBlocks((x$0, xva$1) -> evt.modify(x$0, new Block[]{xva$1})));
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            NeoForgeClientEventInvokers.registerLoadingHandlers();
        }
    }

    private static <T> void onRegistryEntryAdded(RegistryEntryAddedCallback<T> callback, ModifyRegistriesEvent evt, @Nullable Object context) {
        Objects.requireNonNull(context, "context is null");
        ResourceKey resourceKey = (ResourceKey)context;
        Registry registry = evt.getRegistry(resourceKey);
        boolean[] loadComplete = new boolean[1];
        registry.addCallback((RegistryCallback)((AddCallback)(callbackRegistry, id, key, value) -> {
            if (!loadComplete[0]) {
                try {
                    callback.onRegistryEntryAdded(callbackRegistry, key.location(), value, NeoForgeEventInvokerRegistryImpl.onRegistryEntryAdded(registry));
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to run registry entry added callback", (Throwable)exception);
                }
            }
        }));
        registry.addCallback((RegistryCallback)((BakeCallback)registryx -> {
            loadComplete[0] = true;
        }));
        LinkedList<Consumer<BiConsumer>> callbacks = new LinkedList<Consumer<BiConsumer>>();
        for (Map.Entry entry : registry.entrySet()) {
            callbacks.offer(consumer -> {
                try {
                    callback.onRegistryEntryAdded((Registry)registry, ((ResourceKey)entry.getKey()).location(), (Object)entry.getValue(), (BiConsumer)consumer);
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to run registry entry added callback", (Throwable)exception);
                }
            });
        }
        IEventBus eventBus = NeoForgeModContainerHelper.getModEventBus("puzzleslib");
        eventBus.addListener(evtx -> {
            Consumer consumer;
            if (evtx.getRegistryKey() != resourceKey) {
                return;
            }
            while ((consumer = (Consumer)callbacks.poll()) != null) {
                consumer.accept(NeoForgeEventInvokerRegistryImpl.onRegistryEntryAdded(evtx.getRegistry()));
            }
        });
    }

    private static <T> BiConsumer<ResourceLocation, Supplier<T>> onRegistryEntryAdded(Registry<T> registry) {
        return (resourceLocation, supplier) -> {
            try {
                Object t = supplier.get();
                Objects.requireNonNull(t, "entry is null");
                Registry.register((Registry)registry, (ResourceLocation)resourceLocation, t);
            }
            catch (Exception exception) {
                PuzzlesLib.LOGGER.error("Failed to register new entry", (Throwable)exception);
            }
        };
    }

    public static void freezeModBusEvents() {
        frozenModBusEvents = true;
    }

    public static void registerEventHandlers() {
        INSTANCE.register(PlayerInteractEvents.UseBlock.class, PlayerInteractEvent.RightClickBlock.class, (T callback, E evt) -> callback.onUseBlock(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getHitVec()).ifInterrupt(interactionResult -> {
            evt.setCancellationResult(interactionResult);
            evt.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.AttackBlock.class, PlayerInteractEvent.LeftClickBlock.class, (T callback, E evt) -> {
            if (callback.onAttackBlock(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getPos(), evt.getFace()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerInteractEvents.UseItem.class, PlayerInteractEvent.RightClickItem.class, (T callback, E evt) -> callback.onUseItem(evt.getEntity(), evt.getLevel(), evt.getHand()).ifInterrupt(interactionResult -> {
            evt.setCancellationResult(interactionResult);
            evt.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.UseEntity.class, PlayerInteractEvent.EntityInteract.class, (T callback, E evt) -> callback.onUseEntity(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget()).ifInterrupt(interactionResult -> {
            evt.setCancellationResult(interactionResult);
            evt.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.UseEntityAt.class, PlayerInteractEvent.EntityInteractSpecific.class, (T callback, E evt) -> callback.onUseEntityAt(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), evt.getLocalPos()).ifInterrupt(interactionResult -> {
            evt.setCancellationResult(interactionResult);
            evt.setCanceled(true);
        }));
        INSTANCE.register(PlayerInteractEvents.AttackEntity.class, AttackEntityEvent.class, (T callback, E evt) -> {
            if (callback.onAttackEntity(evt.getEntity(), evt.getEntity().level(), InteractionHand.MAIN_HAND, evt.getTarget()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PickupExperienceCallback.class, PlayerXpEvent.PickupXp.class, (T callback, E evt) -> {
            if (callback.onPickupExperience(evt.getEntity(), evt.getOrb()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseBoneMealCallback.class, BonemealEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onUseBoneMeal(evt.getLevel(), evt.getPos(), evt.getState(), evt.getStack());
            if (result.isInterrupt()) {
                evt.setSuccessful(result.getAsBoolean());
            }
        });
        INSTANCE.register(LivingExperienceDropCallback.class, LivingExperienceDropEvent.class, (T callback, E evt) -> {
            DefaultedInt droppedExperience = DefaultedInt.fromEvent(arg_0 -> ((LivingExperienceDropEvent)evt).setDroppedExperience(arg_0), () -> ((LivingExperienceDropEvent)evt).getDroppedExperience(), () -> ((LivingExperienceDropEvent)evt).getOriginalExperience());
            if (callback.onLivingExperienceDrop(evt.getEntity(), evt.getAttackingPlayer(), droppedExperience).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.Break.class, BlockEvent.BreakEvent.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            Player patt1$temp = evt.getPlayer();
            if (!(patt1$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt1$temp;
            if (evt.getState().getBlock() instanceof GameMasterBlock && !serverPlayer.canUseGameMasterBlocks()) {
                return;
            }
            GameType gameType = serverPlayer.gameMode.getGameModeForPlayer();
            if (serverPlayer.blockActionRestricted((Level)evt.getLevel(), evt.getPos(), gameType)) {
                return;
            }
            EventResult result = callback.onBreakBlock(serverLevel, evt.getPos(), evt.getState(), (Player)serverPlayer, serverPlayer.getMainHandItem());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BlockEvents.DropExperience.class, BlockDropsEvent.class, (T callback, E evt) -> {
            Entity patt0$temp = evt.getBreaker();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            MutableInt experienceAmount = MutableInt.fromEvent(arg_0 -> ((BlockDropsEvent)evt).setDroppedExperience(arg_0), () -> ((BlockDropsEvent)evt).getDroppedExperience());
            callback.onDropExperience(evt.getLevel(), evt.getPos(), evt.getState(), (Player)serverPlayer, evt.getTool(), experienceAmount);
        });
        INSTANCE.register(BlockEvents.FarmlandTrample.class, BlockEvent.FarmlandTrampleEvent.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            if (callback.onFarmlandTrample((Level)serverLevel, evt.getPos(), evt.getState(), evt.getFallDistance(), evt.getEntity()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerTickEvents.Start.class, PlayerTickEvent.Pre.class, (T callback, E evt) -> callback.onStartPlayerTick(evt.getEntity()));
        INSTANCE.register(PlayerTickEvents.End.class, PlayerTickEvent.Post.class, (T callback, E evt) -> callback.onEndPlayerTick(evt.getEntity()));
        INSTANCE.register(LivingFallCallback.class, LivingFallEvent.class, (T callback, E evt) -> {
            MutableFloat fallDistance = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), () -> ((LivingFallEvent)evt).getDistance());
            MutableFloat damageMultiplier = MutableFloat.fromEvent(arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0), () -> ((LivingFallEvent)evt).getDamageMultiplier());
            if (callback.onLivingFall(evt.getEntity(), fallDistance, damageMultiplier).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(RegisterCommandsCallback.class, RegisterCommandsEvent.class, (T callback, E evt) -> callback.onRegisterCommands((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext(), evt.getCommandSelection()));
        INSTANCE.register(LootTableLoadEvents.Replace.class, LootTableLoadEvent.class, (T callback, E evt) -> {
            MutableValue<LootTable> table = MutableValue.fromEvent(arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0), () -> ((LootTableLoadEvent)evt).getTable());
            callback.onReplaceLootTable(evt.getName(), table);
        });
        INSTANCE.register(LootTableLoadEvents.Modify.class, LootTableLoadEvent.class, (T callback, E evt) -> callback.onModifyLootTable(evt.getName(), arg_0 -> ((LootTable)evt.getTable()).addPool(arg_0), index -> {
            if (index == 0 && evt.getTable().removePool("main") != null) {
                return true;
            }
            return evt.getTable().removePool("pool" + index) != null;
        }));
        INSTANCE.register(AnvilEvents.Use.class, AnvilRepairEvent.class, (T callback, E evt) -> {
            if (evt.getEntity().level().isClientSide) {
                return;
            }
            MutableFloat breakChance = MutableFloat.fromEvent(arg_0 -> ((AnvilRepairEvent)evt).setBreakChance(arg_0), () -> ((AnvilRepairEvent)evt).getBreakChance());
            callback.onAnvilUse(evt.getEntity(), evt.getLeft(), evt.getRight(), evt.getOutput(), breakChance);
        });
        INSTANCE.register(ItemEntityEvents.Touch.class, ItemEntityPickupEvent.Pre.class, (T callback, E evt) -> {
            EventResult result = callback.onItemTouch(evt.getPlayer(), evt.getItemEntity());
            if (result.isInterrupt()) {
                evt.setCanPickup(result.getAsBoolean() ? TriState.TRUE : TriState.FALSE);
            }
        });
        INSTANCE.register(ItemEntityEvents.Pickup.class, ItemEntityPickupEvent.Post.class, (T callback, E evt) -> callback.onItemPickup(evt.getPlayer(), evt.getItemEntity(), evt.getOriginalStack()));
        INSTANCE.register(ComputeEnchantedLootBonusCallback.class, ComputeEnchantedLootBonusEvent.class, (T callback, E evt) -> {
            MutableInt enchantmentLevel = MutableInt.fromEvent(evt::setEnchantmentLevel, evt::getEnchantmentLevel);
            callback.onComputeEnchantedLootBonus(evt.getEntity(), evt.getDamageSource(), evt.getEnchantment(), enchantmentLevel);
        });
        INSTANCE.register(AnvilEvents.Update.class, AnvilUpdateEvent.class, (T callback, E evt) -> {
            DefaultedValue<ItemStack> output = DefaultedValue.fromEventWithValue(arg_0 -> ((AnvilUpdateEvent)evt).setOutput(arg_0), () -> ((AnvilUpdateEvent)evt).getOutput(), evt.getOutput());
            DefaultedInt enchantmentCost = DefaultedInt.fromEventWithValue(arg_0 -> ((AnvilUpdateEvent)evt).setCost(arg_0), () -> (int)evt.getCost(), (int)evt.getCost());
            DefaultedInt materialCost = DefaultedInt.fromEventWithValue(arg_0 -> ((AnvilUpdateEvent)evt).setMaterialCost(arg_0), () -> ((AnvilUpdateEvent)evt).getMaterialCost(), evt.getMaterialCost());
            EventResult result = callback.onAnvilUpdate(evt.getLeft(), evt.getRight(), output, evt.getName(), enchantmentCost, materialCost, evt.getPlayer());
            if (result.isInterrupt()) {
                if (!result.getAsBoolean()) {
                    evt.setCanceled(true);
                }
            } else {
                evt.setOutput(output.getAsDefault());
                evt.setCost((long)enchantmentCost.getAsDefaultInt());
                evt.setMaterialCost(materialCost.getAsDefaultInt());
            }
        });
        INSTANCE.register(LivingDropsCallback.class, LivingDropsEvent.class, (T callback, E evt) -> {
            if (callback.onLivingDrops(evt.getEntity(), evt.getSource(), evt.getDrops(), evt.isRecentlyHit()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(EntityTickEvents.Start.class, EntityTickEvent.Pre.class, (T callback, E evt) -> {
            if (callback.onStartEntityTick(evt.getEntity()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(EntityTickEvents.End.class, EntityTickEvent.Post.class, (T callback, E evt) -> callback.onEndEntityTick(evt.getEntity()));
        INSTANCE.register(ArrowLooseCallback.class, ArrowLooseEvent.class, (T callback, E evt) -> {
            MutableInt charge = MutableInt.fromEvent(arg_0 -> ((ArrowLooseEvent)evt).setCharge(arg_0), () -> ((ArrowLooseEvent)evt).getCharge());
            if (callback.onArrowLoose(evt.getEntity(), evt.getBow(), evt.getLevel(), charge, evt.hasAmmo()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingHurtCallback.class, LivingDamageEvent.Pre.class, (T callback, E evt) -> {
            MutableFloat damageAmount = MutableFloat.fromEvent(arg_0 -> ((DamageContainer)evt.getContainer()).setNewDamage(arg_0), () -> ((DamageContainer)evt.getContainer()).getNewDamage());
            if (callback.onLivingHurt(evt.getEntity(), evt.getContainer().getSource(), damageAmount).isInterrupt()) {
                evt.getContainer().setNewDamage(0.0f);
            }
        });
        INSTANCE.register(UseItemEvents.Start.class, LivingEntityUseItemEvent.Start.class, (T callback, E evt) -> {
            MutableInt useDuration = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Start)evt).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Start)evt).getDuration());
            if (callback.onUseItemStart(evt.getEntity(), evt.getItem(), useDuration).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Tick.class, LivingEntityUseItemEvent.Tick.class, (T callback, E evt) -> {
            MutableInt useItemRemaining = MutableInt.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Tick)evt).setDuration(arg_0), () -> ((LivingEntityUseItemEvent.Tick)evt).getDuration());
            if (callback.onUseItemTick(evt.getEntity(), evt.getItem(), useItemRemaining).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Stop.class, LivingEntityUseItemEvent.Stop.class, (T callback, E evt) -> {
            if (callback.onUseItemStop(evt.getEntity(), evt.getItem(), evt.getDuration()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(UseItemEvents.Finish.class, LivingEntityUseItemEvent.Finish.class, (T callback, E evt) -> {
            MutableValue<ItemStack> stack = MutableValue.fromEvent(arg_0 -> ((LivingEntityUseItemEvent.Finish)evt).setResultStack(arg_0), () -> ((LivingEntityUseItemEvent.Finish)evt).getResultStack());
            callback.onUseItemFinish(evt.getEntity(), stack, evt.getDuration(), evt.getItem());
        });
        INSTANCE.register(ShieldBlockCallback.class, LivingShieldBlockEvent.class, (T callback, E evt) -> {
            DefaultedFloat blockedDamage = DefaultedFloat.fromEvent(arg_0 -> ((LivingShieldBlockEvent)evt).setBlockedDamage(arg_0), () -> ((LivingShieldBlockEvent)evt).getBlockedDamage(), () -> ((LivingShieldBlockEvent)evt).getOriginalBlockedDamage());
            if (callback.onShieldBlock(evt.getEntity(), evt.getDamageSource(), blockedDamage).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(TagsUpdatedCallback.class, TagsUpdatedEvent.class, (T callback, E evt) -> callback.onTagsUpdated(evt.getRegistryAccess(), evt.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED));
        INSTANCE.register(ExplosionEvents.Start.class, ExplosionEvent.Start.class, (T callback, E evt) -> {
            if (callback.onExplosionStart(evt.getLevel(), evt.getExplosion()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ExplosionEvents.Detonate.class, ExplosionEvent.Detonate.class, (T callback, E evt) -> callback.onExplosionDetonate(evt.getLevel(), evt.getExplosion(), evt.getAffectedBlocks(), evt.getAffectedEntities()));
        INSTANCE.register(SyncDataPackContentsCallback.class, OnDatapackSyncEvent.class, (T callback, E evt) -> evt.getRelevantPlayers().forEach(player -> callback.onSyncDataPackContents((ServerPlayer)player, evt.getPlayer() != null)));
        INSTANCE.register(ServerLifecycleEvents.Starting.class, ServerAboutToStartEvent.class, (T callback, E evt) -> callback.onServerStarting(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.Started.class, ServerStartedEvent.class, (T callback, E evt) -> callback.onServerStarted(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.Stopping.class, ServerStoppingEvent.class, (T callback, E evt) -> callback.onServerStopping(evt.getServer()));
        INSTANCE.register(ServerLifecycleEvents.Stopped.class, ServerStoppedEvent.class, (T callback, E evt) -> callback.onServerStopped(evt.getServer()));
        INSTANCE.register(PlayLevelSoundEvents.AtPosition.class, PlayLevelSoundEvent.AtPosition.class, (T callback, E evt) -> {
            MutableValue<Holder<SoundEvent>> sound = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setSound(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getSound());
            MutableValue<SoundSource> source = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setSource(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getSource());
            DefaultedFloat volume = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setNewVolume(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getNewVolume(), () -> ((PlayLevelSoundEvent.AtPosition)evt).getOriginalVolume());
            DefaultedFloat pitch = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtPosition)evt).setNewPitch(arg_0), () -> ((PlayLevelSoundEvent.AtPosition)evt).getNewPitch(), () -> ((PlayLevelSoundEvent.AtPosition)evt).getOriginalPitch());
            if (callback.onPlaySoundAtPosition(evt.getLevel(), evt.getPosition(), sound, source, volume, pitch).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayLevelSoundEvents.AtEntity.class, PlayLevelSoundEvent.AtEntity.class, (T callback, E evt) -> {
            MutableValue<Holder<SoundEvent>> sound = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setSound(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getSound());
            MutableValue<SoundSource> source = MutableValue.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setSource(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getSource());
            DefaultedFloat volume = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setNewVolume(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getNewVolume(), () -> ((PlayLevelSoundEvent.AtEntity)evt).getOriginalVolume());
            DefaultedFloat pitch = DefaultedFloat.fromEvent(arg_0 -> ((PlayLevelSoundEvent.AtEntity)evt).setNewPitch(arg_0), () -> ((PlayLevelSoundEvent.AtEntity)evt).getNewPitch(), () -> ((PlayLevelSoundEvent.AtEntity)evt).getOriginalPitch());
            if (callback.onPlaySoundAtEntity(evt.getLevel(), evt.getEntity(), sound, source, volume, pitch).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (T callback, E evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            if (callback.onEntityLoad(evt.getEntity(), serverLevel).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from loading in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Spawn.class, EntityJoinLevelEvent.class, (T callback, E evt) -> {
            MobSpawnType mobSpawnType;
            Entity patt1$temp;
            ServerLevel serverLevel;
            block8: {
                block7: {
                    Level patt0$temp = evt.getLevel();
                    if (!(patt0$temp instanceof ServerLevel)) break block7;
                    serverLevel = (ServerLevel)patt0$temp;
                    if (!evt.loadedFromDisk()) break block8;
                }
                return;
            }
            Entity entity = patt1$temp = evt.getEntity();
            if (patt1$temp instanceof Mob) {
                Mob mob = (Mob)patt1$temp;
                mobSpawnType = mob.getSpawnType();
            } else {
                mobSpawnType = null;
            }
            if (callback.onEntitySpawn(entity, serverLevel, mobSpawnType).isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ServerEntityLevelEvents.Unload.class, EntityLeaveLevelEvent.class, (T callback, E evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onEntityUnload(evt.getEntity(), serverLevel);
        });
        INSTANCE.register(LivingDeathCallback.class, LivingDeathEvent.class, (T callback, E evt) -> {
            if (callback.onLivingDeath(evt.getEntity(), evt.getSource()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerTrackingEvents.Start.class, PlayerEvent.StartTracking.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onStartTracking(evt.getTarget(), serverPlayer);
        });
        INSTANCE.register(PlayerTrackingEvents.Stop.class, PlayerEvent.StopTracking.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onStopTracking(evt.getTarget(), serverPlayer);
        });
        INSTANCE.register(PlayerNetworkEvents.LoggedIn.class, PlayerEvent.PlayerLoggedInEvent.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onLoggedIn(serverPlayer);
        });
        INSTANCE.register(PlayerNetworkEvents.LoggedOut.class, PlayerEvent.PlayerLoggedOutEvent.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onLoggedOut(serverPlayer);
        });
        INSTANCE.register(AfterChangeDimensionCallback.class, PlayerEvent.PlayerChangedDimensionEvent.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            ServerLevel originalLevel = serverPlayer.server.getLevel(evt.getFrom());
            ServerLevel newLevel = serverPlayer.server.getLevel(evt.getTo());
            Objects.requireNonNull(originalLevel, "original level is null");
            Objects.requireNonNull(newLevel, "new level is null");
            callback.onAfterChangeDimension(serverPlayer, originalLevel, newLevel);
        });
        INSTANCE.register(BabyEntitySpawnCallback.class, BabyEntitySpawnEvent.class, (T callback, E evt) -> {
            MutableValue<AgeableMob> child = MutableValue.fromEvent(arg_0 -> ((BabyEntitySpawnEvent)evt).setChild(arg_0), () -> ((BabyEntitySpawnEvent)evt).getChild());
            if (callback.onBabyEntitySpawn(evt.getParentA(), evt.getParentB(), child).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(AnimalTameCallback.class, AnimalTameEvent.class, (T callback, E evt) -> {
            if (callback.onAnimalTame(evt.getAnimal(), evt.getTamer()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingAttackCallback.class, LivingIncomingDamageEvent.class, (T callback, E evt) -> {
            if (callback.onLivingAttack(evt.getEntity(), evt.getSource(), evt.getAmount()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(PlayerCopyEvents.Copy.class, PlayerEvent.Clone.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getOriginal();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer originalServerPlayer = (ServerPlayer)patt0$temp;
            Player patt1$temp = evt.getEntity();
            if (!(patt1$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer newServerPlayer = (ServerPlayer)patt1$temp;
            callback.onCopy(originalServerPlayer, newServerPlayer, !evt.isWasDeath());
        });
        INSTANCE.register(PlayerCopyEvents.Respawn.class, PlayerEvent.PlayerRespawnEvent.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onRespawn(serverPlayer, evt.isEndConquered());
        });
        INSTANCE.register(ServerTickEvents.Start.class, ServerTickEvent.Pre.class, (T callback, E evt) -> callback.onStartServerTick(evt.getServer()));
        INSTANCE.register(ServerTickEvents.End.class, ServerTickEvent.Post.class, (T callback, E evt) -> callback.onEndServerTick(evt.getServer()));
        INSTANCE.register(ServerLevelTickEvents.Start.class, LevelTickEvent.Pre.class, (T callback, E evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onStartLevelTick(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerLevelTickEvents.End.class, LevelTickEvent.Post.class, (T callback, E evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onEndLevelTick(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerLevelEvents.Load.class, LevelEvent.Load.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onLevelLoad(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerLevelEvents.Unload.class, LevelEvent.Unload.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            callback.onLevelUnload(serverLevel.getServer(), serverLevel);
        });
        INSTANCE.register(ServerChunkEvents.Load.class, ChunkEvent.Load.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            ChunkAccess patt1$temp = evt.getChunk();
            if (!(patt1$temp instanceof LevelChunk)) {
                return;
            }
            LevelChunk levelChunk = (LevelChunk)patt1$temp;
            callback.onChunkLoad(serverLevel, levelChunk);
        });
        INSTANCE.register(ServerChunkEvents.Unload.class, ChunkEvent.Unload.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            ChunkAccess patt1$temp = evt.getChunk();
            if (!(patt1$temp instanceof LevelChunk)) {
                return;
            }
            LevelChunk levelChunk = (LevelChunk)patt1$temp;
            callback.onChunkUnload(serverLevel, levelChunk);
        });
        INSTANCE.register(ItemEntityEvents.Toss.class, ItemTossEvent.class, (T callback, E evt) -> {
            if (callback.onItemToss(evt.getPlayer(), evt.getEntity()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(LivingKnockBackCallback.class, LivingKnockBackEvent.class, (T callback, E evt) -> {
            DefaultedDouble strength = DefaultedDouble.fromEvent(v -> evt.setStrength((float)v), () -> ((LivingKnockBackEvent)evt).getStrength(), () -> ((LivingKnockBackEvent)evt).getOriginalStrength());
            DefaultedDouble ratioX = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)evt).setRatioX(arg_0), () -> ((LivingKnockBackEvent)evt).getRatioX(), () -> ((LivingKnockBackEvent)evt).getOriginalRatioX());
            DefaultedDouble ratioZ = DefaultedDouble.fromEvent(arg_0 -> ((LivingKnockBackEvent)evt).setRatioZ(arg_0), () -> ((LivingKnockBackEvent)evt).getRatioZ(), () -> ((LivingKnockBackEvent)evt).getOriginalRatioZ());
            if (callback.onLivingKnockBack(evt.getEntity(), strength, ratioX, ratioZ).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(ProjectileImpactCallback.class, ProjectileImpactEvent.class, (T callback, E evt) -> {
            if (callback.onProjectileImpact(evt.getProjectile(), evt.getRayTraceResult()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(BreakSpeedCallback.class, PlayerEvent.BreakSpeed.class, (T callback, E evt) -> {
            DefaultedFloat breakSpeed = DefaultedFloat.fromEvent(arg_0 -> ((PlayerEvent.BreakSpeed)evt).setNewSpeed(arg_0), () -> ((PlayerEvent.BreakSpeed)evt).getNewSpeed(), () -> ((PlayerEvent.BreakSpeed)evt).getOriginalSpeed());
            if (callback.onBreakSpeed(evt.getEntity(), evt.getState(), breakSpeed).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Affects.class, MobEffectEvent.Applicable.class, (T callback, E evt) -> {
            EventResult result = callback.onMobEffectAffects(evt.getEntity(), evt.getEffectInstance());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? MobEffectEvent.Applicable.Result.APPLY : MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        });
        INSTANCE.register(MobEffectEvents.Apply.class, MobEffectEvent.Added.class, (T callback, E evt) -> callback.onMobEffectApply(evt.getEntity(), evt.getEffectInstance(), evt.getOldEffectInstance(), evt.getEffectSource()));
        INSTANCE.register(MobEffectEvents.Remove.class, MobEffectEvent.Remove.class, (T callback, E evt) -> {
            if (callback.onMobEffectRemove(evt.getEntity(), evt.getEffectInstance()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(MobEffectEvents.Expire.class, MobEffectEvent.Expired.class, (T callback, E evt) -> callback.onMobEffectExpire(evt.getEntity(), evt.getEffectInstance()));
        INSTANCE.register(LivingJumpCallback.class, LivingEvent.LivingJumpEvent.class, (T callback, E evt) -> EventImplHelper.onLivingJump(callback, evt.getEntity()));
        INSTANCE.register(LivingVisibilityCallback.class, LivingEvent.LivingVisibilityEvent.class, (T callback, E evt) -> callback.onLivingVisibility(evt.getEntity(), evt.getLookingEntity(), MutableDouble.fromEvent(visibilityModifier -> evt.modifyVisibility(visibilityModifier / evt.getVisibilityModifier()), () -> ((LivingEvent.LivingVisibilityEvent)evt).getVisibilityModifier())));
        INSTANCE.register(LivingChangeTargetCallback.class, LivingChangeTargetEvent.class, (T callback, E evt) -> {
            DefaultedValue<LivingEntity> target = DefaultedValue.fromEvent(arg_0 -> ((LivingChangeTargetEvent)evt).setNewAboutToBeSetTarget(arg_0), () -> ((LivingChangeTargetEvent)evt).getNewAboutToBeSetTarget(), () -> ((LivingChangeTargetEvent)evt).getOriginalAboutToBeSetTarget());
            if (callback.onLivingChangeTarget(evt.getEntity(), target).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(CheckMobDespawnCallback.class, MobDespawnEvent.class, (T callback, E evt) -> {
            ServerLevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            EventResult result = callback.onCheckMobDespawn(evt.getEntity(), serverLevel);
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? MobDespawnEvent.Result.ALLOW : MobDespawnEvent.Result.DENY);
            }
        });
        INSTANCE.register(GatherPotentialSpawnsCallback.class, LevelEvent.PotentialSpawns.class, (T callback, E evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            PotentialSpawnsList<MobSpawnSettings.SpawnerData> mobs = new PotentialSpawnsList<MobSpawnSettings.SpawnerData>(() -> ((LevelEvent.PotentialSpawns)evt).getSpawnerDataList(), spawnerData -> {
                evt.addSpawnerData(spawnerData);
                return true;
            }, arg_0 -> ((LevelEvent.PotentialSpawns)evt).removeSpawnerData(arg_0));
            callback.onGatherPotentialSpawns(serverLevel, serverLevel.structureManager(), serverLevel.getChunkSource().getGenerator(), evt.getMobCategory(), evt.getPos(), mobs);
        });
        INSTANCE.register(EntityRidingEvents.Start.class, EntityMountEvent.class, (T callback, E evt) -> {
            if (evt.isDismounting()) {
                return;
            }
            if (!evt.getEntityMounting().canRide(evt.getEntityBeingMounted())) {
                return;
            }
            if (!evt.getEntityBeingMounted().canAddPassenger(evt.getEntityMounting())) {
                return;
            }
            if (callback.onStartRiding(evt.getLevel(), evt.getEntityMounting(), evt.getEntityBeingMounted()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(EntityRidingEvents.Stop.class, EntityMountEvent.class, (T callback, E evt) -> {
            if (evt.isMounting()) {
                return;
            }
            if (callback.onStopRiding(evt.getLevel(), evt.getEntity(), evt.getEntityBeingMounted()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(GrindstoneEvents.Update.class, GrindstoneEvent.OnPlaceItem.class, (T callback, E evt) -> {
            ItemStack originalOutput = evt.getOutput();
            int originalExperienceReward = evt.getXp();
            MutableValue<ItemStack> output = MutableValue.fromEvent(arg_0 -> ((GrindstoneEvent.OnPlaceItem)evt).setOutput(arg_0), () -> ((GrindstoneEvent.OnPlaceItem)evt).getOutput());
            MutableInt experienceReward = MutableInt.fromEvent(arg_0 -> ((GrindstoneEvent.OnPlaceItem)evt).setXp(arg_0), () -> ((GrindstoneEvent.OnPlaceItem)evt).getXp());
            Player player = EventImplHelper.getGrindstoneUsingPlayer(evt.getTopItem(), evt.getBottomItem()).orElseThrow(NullPointerException::new);
            EventResult result = callback.onGrindstoneUpdate(evt.getTopItem(), evt.getBottomItem(), output, experienceReward, player);
            if (result.isInterrupt()) {
                if (!result.getAsBoolean()) {
                    evt.setCanceled(true);
                }
            } else {
                evt.setOutput(originalOutput);
                evt.setXp(originalExperienceReward);
            }
        });
        INSTANCE.register(GrindstoneEvents.Use.class, GrindstoneEvent.OnTakeItem.class, (T callback, E evt) -> {
            DefaultedValue<ItemStack> topInput = DefaultedValue.fromValue(evt.getTopItem());
            if (!evt.getNewTopItem().isEmpty()) {
                topInput.accept(evt.getNewTopItem());
            }
            DefaultedValue<ItemStack> bottomInput = DefaultedValue.fromValue(evt.getBottomItem());
            if (!evt.getNewBottomItem().isEmpty()) {
                bottomInput.accept(evt.getNewBottomItem());
            }
            Player player = EventImplHelper.getGrindstoneUsingPlayer(evt.getTopItem(), evt.getBottomItem()).orElseThrow(NullPointerException::new);
            callback.onGrindstoneUse(topInput, bottomInput, player);
            topInput.getAsOptional().ifPresent(arg_0 -> ((GrindstoneEvent.OnTakeItem)evt).setNewTopItem(arg_0));
            bottomInput.getAsOptional().ifPresent(arg_0 -> ((GrindstoneEvent.OnTakeItem)evt).setNewBottomItem(arg_0));
        });
        INSTANCE.register(LivingBreathEvents.Breathe.class, LivingBreatheEvent.class, (T callback, E evt) -> {
            boolean canLoseAir;
            int airAmountValue = evt.canBreathe() ? evt.getRefillAirAmount() : -evt.getConsumeAirAmount();
            DefaultedInt airAmount = DefaultedInt.fromValue(airAmountValue);
            LivingEntity entity = evt.getEntity();
            EventResult result = callback.onLivingBreathe(entity, airAmount, true, canLoseAir = !entity.canDrownInFluidType(entity.getEyeInFluidType()) && !MobEffectUtil.hasWaterBreathing((LivingEntity)entity) && (!(entity instanceof Player) || !((Player)entity).getAbilities().invulnerable));
            if (result.isInterrupt()) {
                evt.setConsumeAirAmount(0);
                evt.setRefillAirAmount(0);
            } else {
                OptionalInt optional = airAmount.getAsOptionalInt();
                if (optional.isPresent()) {
                    if (optional.getAsInt() < 0) {
                        evt.setCanBreathe(false);
                        evt.setConsumeAirAmount(Math.abs(optional.getAsInt()));
                        evt.setRefillAirAmount(0);
                    } else {
                        evt.setCanBreathe(true);
                        evt.setConsumeAirAmount(0);
                        evt.setRefillAirAmount(Math.abs(optional.getAsInt()));
                    }
                }
            }
        });
        INSTANCE.register(LivingBreathEvents.Drown.class, LivingDrownEvent.class, (T callback, E evt) -> {
            EventResult result = callback.onLivingDrown(evt.getEntity(), evt.getEntity().getAirSupply(), evt.isDrowning());
            if (result.isInterrupt()) {
                if (result.getAsBoolean()) {
                    evt.setDrowning(true);
                } else {
                    evt.setCanceled(true);
                }
            }
        });
        INSTANCE.register(ServerChunkEvents.Watch.class, ChunkWatchEvent.Watch.class, (T callback, E evt) -> callback.onChunkWatch(evt.getPlayer(), evt.getChunk(), evt.getLevel()));
        INSTANCE.register(ServerChunkEvents.Unwatch.class, ChunkWatchEvent.UnWatch.class, (T callback, E evt) -> callback.onChunkUnwatch(evt.getPlayer(), evt.getPos(), evt.getLevel()));
        INSTANCE.register(LivingEquipmentChangeCallback.class, LivingEquipmentChangeEvent.class, (T callback, E evt) -> callback.onLivingEquipmentChange(evt.getEntity(), evt.getSlot(), evt.getFrom(), evt.getTo()));
        INSTANCE.register(LivingConversionCallback.class, LivingConversionEvent.Post.class, (T callback, E evt) -> callback.onLivingConversion(evt.getEntity(), evt.getOutcome()));
        INSTANCE.register(ContainerEvents.Open.class, PlayerContainerEvent.Open.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onContainerOpen(serverPlayer, evt.getContainer());
        });
        INSTANCE.register(ContainerEvents.Close.class, PlayerContainerEvent.Close.class, (T callback, E evt) -> {
            Player patt0$temp = evt.getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            callback.onContainerClose(serverPlayer, evt.getContainer());
        });
        INSTANCE.register(LookingAtEndermanCallback.class, EnderManAngerEvent.class, (T callback, E evt) -> {
            if (callback.onLookingAtEnderManCallback(evt.getEntity(), evt.getPlayer()).isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        INSTANCE.register(RegisterPotionBrewingMixesCallback.class, RegisterBrewingRecipesEvent.class, (T callback, E evt) -> callback.onRegisterPotionBrewingMixes(new NeoForgePotionBrewingBuilder(evt.getBuilder())));
        INSTANCE.register(AddDataPackReloadListenersCallback.class, AddReloadListenerEvent.class, (T callback, E evt) -> callback.onAddDataPackReloadListeners((resourceLocation, factory) -> {
            HolderLookup.Provider registryLookup = evt.getServerResources().getRegistryLookup();
            evt.addListener(ForwardingReloadListenerHelper.fromReloadListener(resourceLocation, (PreparableReloadListener)factory.apply(registryLookup, evt.getRegistryAccess())));
        }));
        INSTANCE.register(ChangeEntitySizeCallback.class, EntityEvent.Size.class, (T callback, E evt) -> {
            EventResultHolder<EntityDimensions> result = callback.onChangeEntitySize(evt.getEntity(), evt.getPose(), evt.getOldSize());
            result.ifInterrupt(arg_0 -> ((EntityEvent.Size)evt).setNewSize(arg_0));
        });
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            NeoForgeClientEventInvokers.registerEventHandlers();
        }
    }

    @Override
    public <T, E extends Event> void register(Class<T> clazz, Class<E> event, NeoForgeEventInvokerRegistry.NeoForgeEventContextConsumer<T, E> converter, boolean joinInvokers) {
        IEventBus eventBus;
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(event, "event type is null");
        Objects.requireNonNull(converter, "converter is null");
        Preconditions.checkArgument((!Modifier.isAbstract(event.getModifiers()) ? 1 : 0) != 0, (Object)(String.valueOf(event) + " is abstract"));
        if (IModBusEvent.class.isAssignableFrom(event)) {
            Preconditions.checkState((!frozenModBusEvents ? 1 : 0) != 0, (Object)"Mod bus events already frozen");
            eventBus = NeoForgeModContainerHelper.getOptionalActiveModEventBus().orElse(null);
        } else {
            eventBus = NeoForge.EVENT_BUS;
        }
        EventInvokerImpl.register(clazz, new ForgeEventInvoker<T, E>(eventBus, event, converter), joinInvokers);
    }

    private record ForgeEventInvoker<T, E extends Event>(@Nullable IEventBus eventBus, Class<E> event, NeoForgeEventInvokerRegistry.NeoForgeEventContextConsumer<T, E> converter) implements EventInvoker<T>,
    EventInvokerImpl.EventInvokerLike<T>
    {
        private static final Map<EventPhase, EventPriority> PHASE_TO_PRIORITY = Map.of(EventPhase.FIRST, EventPriority.HIGHEST, EventPhase.BEFORE, EventPriority.HIGH, EventPhase.DEFAULT, EventPriority.NORMAL, EventPhase.AFTER, EventPriority.LOW, EventPhase.LAST, EventPriority.LOWEST);

        @Override
        public EventInvoker<T> asEventInvoker(@Nullable Object context) {
            return context != null ? (phase, callback) -> this.register(phase, callback, context) : this;
        }

        @Override
        public void register(EventPhase phase, T callback) {
            this.register(phase, callback, null);
        }

        private void register(EventPhase phase, T callback, @Nullable Object context) {
            Objects.requireNonNull(phase, "phase is null");
            Objects.requireNonNull(callback, "callback is null");
            IEventBus eventBus = this.getEventBus(context);
            EventPriority eventPriority = PHASE_TO_PRIORITY.getOrDefault(phase, EventPriority.NORMAL);
            Object eventContext = this.eventBus != eventBus ? null : context;
            eventBus.addListener(eventPriority, false, this.event, evt -> this.converter.accept(callback, (Event)evt, eventContext));
        }

        private IEventBus getEventBus(@Nullable Object context) {
            if (this.eventBus == null) {
                Objects.requireNonNull(context, "mod id context is null");
                return NeoForgeModContainerHelper.getModEventBus((String)context);
            }
            return this.eventBus;
        }
    }
}

