/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.annotation;

import com.google.common.collect.HashMultimap;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.impl.config.ConfigDataHolderImpl;
import fuzs.puzzleslib.impl.config.annotation.ConfigEntry;
import fuzs.puzzleslib.impl.config.annotation.LimitedEntry;
import fuzs.puzzleslib.impl.config.annotation.NumberEntry;
import fuzs.puzzleslib.impl.config.annotation.ValueEntry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigBuilder {
    private ConfigBuilder() {
    }

    public static <T extends ConfigCore> void build(ModConfigSpec.Builder builder, ConfigDataHolderImpl<?> context, @NotNull T o) {
        Objects.requireNonNull(o, "object is null");
        ConfigBuilder.build(builder, context, o.getClass(), o);
    }

    public static <T extends ConfigCore> void build(ModConfigSpec.Builder builder, ConfigDataHolderImpl<?> context, Class<? extends T> clazz) {
        ConfigBuilder.build(builder, context, clazz, null);
    }

    public static <T extends ConfigCore> void build(ModConfigSpec.Builder builder, ConfigDataHolderImpl<?> context, Class<? extends T> clazz, @Nullable T o) {
        Objects.requireNonNull(clazz, "clazz is null");
        Map<List<String>, Collection<Field>> pathToFields = ConfigBuilder.getAllFieldsWithPath(clazz);
        for (Map.Entry<List<String>, Collection<Field>> entry : pathToFields.entrySet()) {
            List<String> path = entry.getKey();
            if (!path.isEmpty()) {
                for (String category : path) {
                    builder.push(category);
                }
            }
            for (Field field : entry.getValue()) {
                field.setAccessible(true);
                boolean isStatic = Modifier.isStatic(field.getModifiers());
                if (!isStatic) {
                    Objects.requireNonNull(o, "Null instance for non-static field");
                }
                ConfigEntry<?> configEntry = ConfigBuilder.getConfigEntry(field);
                configEntry.defineValue(builder, context, isStatic ? null : o);
            }
            if (path.isEmpty()) continue;
            builder.pop(path.size());
        }
        if (o != null) {
            o.addToBuilder(builder, context);
            context.acceptValueCallback(o::afterConfigReload);
        }
    }

    private static Map<List<String>, Collection<Field>> getAllFieldsWithPath(Class<?> target) {
        HashMultimap paths = HashMultimap.create();
        for (Field field : ConfigBuilder.collectAllFields(target)) {
            Config config = field.getDeclaredAnnotation(Config.class);
            if (config == null) continue;
            paths.put(new ArrayList<String>(Arrays.asList(config.category())), (Object)field);
        }
        return paths.asMap();
    }

    private static List<Field> collectAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static ConfigEntry<?> getConfigEntry(Field field) {
        ConfigEntry configEntry;
        Class<?> clazz = field.getType();
        Objects.requireNonNull(clazz);
        Class<?> clazz2 = clazz;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class}, clazz2, n)) {
                case 0: {
                    Class<?> clazz3 = clazz2;
                    if (!ConfigCore.class.isAssignableFrom(clazz3)) {
                        n = 1;
                        continue block10;
                    }
                    configEntry = new ConfigEntry.ChildEntry(field);
                    break block10;
                }
                case 1: {
                    Class<?> clazz4 = clazz2;
                    if (clazz4 != Boolean.TYPE) {
                        n = 2;
                        continue block10;
                    }
                    configEntry = new ValueEntry.BooleanEntry(field);
                    break block10;
                }
                case 2: {
                    Class<?> clazz5 = clazz2;
                    if (clazz5 != Integer.TYPE) {
                        n = 3;
                        continue block10;
                    }
                    configEntry = new NumberEntry.IntegerEntry(field);
                    break block10;
                }
                case 3: {
                    Class<?> clazz6 = clazz2;
                    if (clazz6 != Long.TYPE) {
                        n = 4;
                        continue block10;
                    }
                    configEntry = new NumberEntry.LongEntry(field);
                    break block10;
                }
                case 4: {
                    Class<?> clazz7 = clazz2;
                    if (clazz7 != Double.TYPE) {
                        n = 5;
                        continue block10;
                    }
                    configEntry = new NumberEntry.DoubleEntry(field);
                    break block10;
                }
                case 5: {
                    Class<?> clazz8 = clazz2;
                    if (clazz8 != String.class) {
                        n = 6;
                        continue block10;
                    }
                    configEntry = new LimitedEntry.StringEntry(field);
                    break block10;
                }
                case 6: {
                    Class<?> clazz9 = clazz2;
                    if (!clazz9.isEnum()) {
                        n = 7;
                        continue block10;
                    }
                    configEntry = new LimitedEntry.EnumEntry(field);
                    break block10;
                }
                case 7: {
                    Class<?> clazz10 = clazz2;
                    if (clazz10 != List.class) {
                        n = 8;
                        continue block10;
                    }
                    configEntry = new LimitedEntry.ListEntry(field);
                    break block10;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported config value type: " + String.valueOf(field.getType()));
                }
            }
            break;
        }
        return configEntry;
    }
}

