/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.event.v1.data;

import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.impl.event.data.EventDefaultedValue;
import fuzs.puzzleslib.impl.event.data.ValueDefaultedValue;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface DefaultedValue<T>
extends MutableValue<T> {
    public static <T> DefaultedValue<T> fromValue(T value) {
        return new ValueDefaultedValue<T>(value);
    }

    public static <T> DefaultedValue<T> fromEvent(Consumer<T> consumer, Supplier<T> supplier, Supplier<T> defaultSupplier) {
        return new EventDefaultedValue<T>(consumer, supplier, defaultSupplier);
    }

    public static <T> DefaultedValue<T> fromEventWithValue(Consumer<T> consumer, Supplier<T> supplier, T defaultValue) {
        return DefaultedValue.fromEvent(consumer, supplier, () -> defaultValue);
    }

    public T getAsDefault();

    public Optional<T> getAsOptional();

    default public void applyDefault() {
        this.accept(this.getAsDefault());
    }

    default public void mapDefault(UnaryOperator<T> operator) {
        this.applyDefault();
        this.map(operator);
    }
}

